sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/cas/CASLibraryItem", "./CASTable"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CASLibrary = ltjsEnvironment_1.createModule([114, 13, 50265, 50036], EventDispatcher_1.default);
    /**
     *
     */
    CASLibrary._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CASLibrary_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CASLibrary)", "static", "new", "-->", "(transport::CASLibrary)", rc);
        return rc;
    };
    /**
     * @return {CASLibraryItem| null}
     */
    CASLibrary.prototype.getDetails = function () {
        var details_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("details");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), details_jni);
        //-- Convert abstract(transport::CASLibraryItem) from jni(size_t) to js(CASLibraryItem)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASLibrary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#details", "-->", "(transport::CASLibraryItem)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {CASLibraryItem| null} value
     *
     */
    CASLibrary.prototype.setDetails = function (value) {
        //-- Convert abstract(transport::CASLibraryItem) from js(CASLibraryItem) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var details_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("details");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, details_name_jni);
        Module.deps['TraceUtil'].log("(transport::CASLibrary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#details", "(transport::CASLibraryItem)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Array.<CASTable| null> | null}
     */
    CASLibrary.prototype.getTables = function () {
        var tables_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("tables");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), tables_jni);
        //-- Convert abstract(<transport::CASTable>) from jni(size_t) to js(CASTable)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CASLibrary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#tables", "-->", "(MONITORED_VECTOR<transport::CASTable>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<CASTable| null> | null} value
     *
     */
    CASLibrary.prototype.setTables = function (value) {
        //-- Convert abstract(<transport::CASTable>) from js(CASTable) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var tables_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("tables");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, tables_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::CASLibrary)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#tables", "(MONITORED_VECTOR<transport::CASTable>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    exports.default = CASLibrary;
});
