sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "sas/ltjs/transport/models/media/ReportMetadata", "./Connection"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var BaseReport = ltjsEnvironment_1.createModule([114, 13, 50265, 50029], EventDispatcher_1.default);
    BaseReport.UNSUBSCRIBED = 60035;
    BaseReport.SUBSCRIBED = 60036;
    BaseReport.PROMOTION = 60037;
    /**
     *
     */
    BaseReport._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_BaseReport_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::BaseReport)", "static", "new", "-->", "(transport::BaseReport)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    BaseReport.prototype.getUuid = function () {
        var uuid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("uuid");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), uuid_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#uuid", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @return {ReportMetadata| null}
     */
    BaseReport.prototype.getMeta = function () {
        var meta_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("meta");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), meta_jni);
        //-- Convert abstract(transport::ReportMetadata) from jni(size_t) to js(ReportMetadata)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#meta", "-->", "(transport::ReportMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {ReportMetadata| null} value
     *
     */
    BaseReport.prototype.setMeta = function (value) {
        //-- Convert abstract(transport::ReportMetadata) from js(ReportMetadata) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var meta_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("meta");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, meta_name_jni);
        Module.deps['TraceUtil'].log("(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#meta", "(transport::ReportMetadata)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Connection| null}
     */
    BaseReport.prototype.getConnection = function () {
        var connection_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connection");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::Connection) from jni(size_t) to js(Connection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connection", "-->", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} value
     *
     */
    BaseReport.prototype.setConnection = function (value) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var connection_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connection");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, connection_name_jni);
        Module.deps['TraceUtil'].log("(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connection", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    BaseReport.prototype.getPromoted = function () {
        var promoted_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("promoted");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), promoted_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#promoted", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    BaseReport.prototype.setPromoted = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var promoted_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("promoted");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, promoted_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#promoted", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * Returns the created by or modified by user name, with placeholder values when the user name is missing due to 'fake' userids often used for batch loading reports.
     * @param {UserNameContext| null} context
     * @return {string| null}
     */
    BaseReport.prototype.getUserName = function (context) {
        //-- Convert abstract(transport::UserNameContext) from js(UserNameContext) to jni(size_t)
        var context_jni = ClosetObject_1.default._getValidClosetAddress(context);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_BaseReport_getUserName(this._getValidClosetAddress(), context_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getUserName", "(transport::UserNameContext)", Module.deps['TraceUtil'].traceConversions.convertModel(context), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    exports.default = BaseReport;
});
