sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/commons/models/BaseModel"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var TransportModel = ltjsEnvironment_1.createModule([114, 13, 50265], EventDispatcher_1.default);
    /**
     * @param {number} maxRecursionDepth
     * @return {string| null}
     */
    TransportModel.prototype.getDescription = function (maxRecursionDepth) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var maxRecursionDepth_jni = maxRecursionDepth;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_TransportModel_getDescription(this._getValidClosetAddress(), maxRecursionDepth_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getDescription", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(maxRecursionDepth), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    exports.default = TransportModel;
});
