sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/media/MediaType", "sas/ltjs/transport/models/media/ReportImageInfo"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ReportImageCacheEntry = ltjsEnvironment_1.createModule([114, 13, 50265, 50161, 50199], EventDispatcher_1.default);
    /**
     *
     */
    ReportImageCacheEntry._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ReportImageCacheEntry_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageCacheEntry)", "static", "new", "-->", "(transport::ReportImageCacheEntry)", rc);
        return rc;
    };
    /**
     * @return {Array.<ReportImageInfo| null> | null}
     */
    ReportImageCacheEntry.prototype.getInfos = function () {
        var infos_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("infos");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableVectorProperty(this._getValidClosetAddress(), infos_jni);
        //-- Convert abstract(<transport::ReportImageInfo>) from jni(size_t) to js(ReportImageInfo)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageCacheEntry)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#infos", "-->", "(MONITORED_VECTOR<transport::ReportImageInfo>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Array.<ReportImageInfo| null> | null} value
     *
     */
    ReportImageCacheEntry.prototype.setInfos = function (value) {
        //-- Convert abstract(<transport::ReportImageInfo>) from js(ReportImageInfo) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertObjectArrayToC(value);
        var infos_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("infos");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableVectorProperty(this._getValidClosetAddress(), value_jni, infos_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageCacheEntry)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#infos", "(MONITORED_VECTOR<transport::ReportImageInfo>)", Module.deps['TraceUtil'].traceConversions.convertArray(value, Module.deps['TraceUtil'].traceConversions.convertModel));
        return this;
    };
    /**
     * @return {number}
     */
    ReportImageCacheEntry.prototype.getDownloadDatetime = function () {
        var downloadDatetime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadDatetime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getSASDatetimeProperty(this._getValidClosetAddress(), downloadDatetime_jni);
        //-- Convert abstract(commons::SASDATETIME) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ReportImageCacheEntry)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadDatetime", "-->", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    ReportImageCacheEntry.prototype.setDownloadDatetime = function (value) {
        //-- Convert abstract(commons::SASDATETIME) from js(number) to jni(double)
        var value_jni = value;
        var downloadDatetime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadDatetime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setSASDatetimeProperty(this._getValidClosetAddress(), value_jni, downloadDatetime_name_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageCacheEntry)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadDatetime", "(commons::SASDATETIME)", Module.deps['TraceUtil'].traceConversions.convertDouble(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    ReportImageCacheEntry.prototype.getDownloadPath = function () {
        var downloadPath_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadPath");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), downloadPath_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageCacheEntry)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadPath", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    ReportImageCacheEntry.prototype.setDownloadPath = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var downloadPath_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadPath");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, downloadPath_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::ReportImageCacheEntry)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadPath", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    exports.default = ReportImageCacheEntry;
});
