sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/transport/lib", "sas/ltjs/commons/events/PortableEvent", "sas/ltjs/transport/models/TransportModel", "./warnings/TransportWarning", "./Voucher"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var VoucherEvent = ltjsEnvironment_1.createModule([110, 50283], ClosetObject_1.default);
    /**
     * @return {TransportModel| null}
     */
    VoucherEvent.prototype.getRequestedResource = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_VoucherEvent_getRequestedResource(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportModel) from jni(size_t) to js(TransportModel)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::VoucherEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getRequestedResource", "-->", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    VoucherEvent.prototype.getWarning = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_VoucherEvent_getWarning(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::VoucherEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getWarning", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {Voucher| null}
     */
    VoucherEvent.prototype.getVoucher = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_VoucherEvent_getVoucher(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::VoucherEvent)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getVoucher", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = VoucherEvent;
});
