sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/models/TransportModel", "./warnings/TransportWarning"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Voucher = ltjsEnvironment_1.createModule([50282], EventDispatcher_1.default);
    Voucher.WARNING = 60082;
    Voucher.FULFILLED = 60083;
    Voucher.CANCELLED = 60084;
    Voucher.ISSUED = 60085;
    /**
     * @return {TransportModel| null}
     */
    Voucher.prototype.getRequestedResource = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Voucher_getRequestedResource(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportModel) from jni(size_t) to js(TransportModel)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getRequestedResource", "-->", "(transport::TransportModel)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    Voucher.prototype.getWarning = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Voucher_getWarning(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getWarning", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {number}
     */
    Voucher.prototype.getType = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Voucher_getType(this._getValidClosetAddress());
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getType", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @return {boolean}
     */
    Voucher.prototype.isCompleted = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Voucher_isCompleted(this._getValidClosetAddress());
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isCompleted", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     *
     */
    Voucher.prototype.cancel = function () {
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Voucher_cancel(this._getValidClosetAddress());
        Module.deps['TraceUtil'].log("(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "cancel");
        return this;
    };
    exports.default = Voucher;
});
