sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./Voucher"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ThumbnailManager = ltjsEnvironment_1.createModule([50257, 50264], EventDispatcher_1.default);
    ThumbnailManager.FAILED = 60079;
    ThumbnailManager.FINISHED = 60080;
    ThumbnailManager.STARTED = 60081;
    /**
     * @param {BaseReport| null} report
     * @return {Voucher| null}
     */
    ThumbnailManager.prototype.getPreviewThumbnail = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_getPreviewThumbnail(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getPreviewThumbnail", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @return {Array.<string| null> | null}
     */
    ThumbnailManager.prototype.getSectionThumbnails = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_getSectionThumbnails(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSectionThumbnails", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(ARRAY<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {string| null} sectionName
     * @param {boolean} fallbackWithServerThumbnailOnSectionNameNotFound
     * @return {string| null}
     */
    ThumbnailManager.prototype.getSectionThumbnail = function (report, sectionName, fallbackWithServerThumbnailOnSectionNameNotFound) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var sectionName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(sectionName);
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var fallbackWithServerThumbnailOnSectionNameNotFound_jni = !!fallbackWithServerThumbnailOnSectionNameNotFound;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_getSectionThumbnail(this._getValidClosetAddress(), report_jni, sectionName_jni, fallbackWithServerThumbnailOnSectionNameNotFound_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(sectionName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSectionThumbnail", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(sectionName), "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(fallbackWithServerThumbnailOnSectionNameNotFound), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {ReportImageSize} size
     * @return {Voucher| null}
     */
    ThumbnailManager.prototype.getReportImageLink = function (report, size) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var size_jni = size;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_getReportImageLink(this._getValidClosetAddress(), report_jni, size_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReportImageLink", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(size), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {ReportImageSize} size
     * @return {Voucher| null}
     */
    ThumbnailManager.prototype.getAllSectionImageLinks = function (report, size) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var size_jni = size;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_getAllSectionImageLinks(this._getValidClosetAddress(), report_jni, size_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getAllSectionImageLinks", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(size), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {ReportImageSize} size
     * @return {Voucher| null}
     */
    ThumbnailManager.prototype.downloadReportImage = function (report, size) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var size_jni = size;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_downloadReportImage(this._getValidClosetAddress(), report_jni, size_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "downloadReportImage", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(size), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {ReportImageSize} size
     * @return {Voucher| null}
     */
    ThumbnailManager.prototype.downloadAllSectionImages = function (report, size) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var size_jni = size;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_downloadAllSectionImages(this._getValidClosetAddress(), report_jni, size_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "downloadAllSectionImages", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(size), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {string| null} sectionName
     * @param {ReportImageSize} size
     * @return {string| null}
     */
    ThumbnailManager.prototype.getDownloadedSectionImagePath = function (report, sectionName, size) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var sectionName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(sectionName);
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var size_jni = size;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_getDownloadedSectionImagePath(this._getValidClosetAddress(), report_jni, sectionName_jni, size_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(sectionName_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getDownloadedSectionImagePath", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(sectionName), "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(size), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {number} sectionIndex
     * @param {ReportImageSize} size
     * @return {string| null}
     */
    ThumbnailManager.prototype.getDownloadedSectionImagePathByIndex = function (report, sectionIndex, size) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var sectionIndex_jni = sectionIndex;
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var size_jni = size;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_getDownloadedSectionImagePathByIndex(this._getValidClosetAddress(), report_jni, sectionIndex_jni, size_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getDownloadedSectionImagePathByIndex", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(sectionIndex), "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(size), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {ReportImageSize} size
     * @return {string| null}
     */
    ThumbnailManager.prototype.getDownloadedReportImagePath = function (report, size) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var size_jni = size;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_getDownloadedReportImagePath(this._getValidClosetAddress(), report_jni, size_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getDownloadedReportImagePath", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(size), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @return {string| null}
     */
    ThumbnailManager.prototype.getGeneratedThumbnailDirectoryPath = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_getGeneratedThumbnailDirectoryPath(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getGeneratedThumbnailDirectoryPath", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {number} section
     * @return {string| null}
     */
    ThumbnailManager.prototype.getGeneratedThumbnailPath = function (report, section) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::UNSIGNED) from js(number) to jni(int)
        var section_jni = section;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_getGeneratedThumbnailPath(this._getValidClosetAddress(), report_jni, section_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getGeneratedThumbnailPath", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(section), "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {number} section
     * @return {boolean}
     */
    ThumbnailManager.prototype.hasPreviewForSection = function (report, section) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::UNSIGNED) from js(number) to jni(int)
        var section_jni = section;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_hasPreviewForSection(this._getValidClosetAddress(), report_jni, section_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "hasPreviewForSection", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(section), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     *
     */
    ThumbnailManager.prototype.notifyGenerationStarted = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_notifyGenerationStarted(this._getValidClosetAddress(), report_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "notifyGenerationStarted", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report));
        return this;
    };
    /**
     * @param {BaseReport| null} report
     * @param {number} section
     *
     */
    ThumbnailManager.prototype.notifyThumbnailGenerated = function (report, section) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::UNSIGNED) from js(number) to jni(int)
        var section_jni = section;
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_notifyThumbnailGenerated(this._getValidClosetAddress(), report_jni, section_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "notifyThumbnailGenerated", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::UNSIGNED)", Module.deps['TraceUtil'].traceConversions.convertUnsigned(section));
        return this;
    };
    /**
     * @param {BaseReport| null} report
     *
     */
    ThumbnailManager.prototype.notifyGenerationFinished = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_notifyGenerationFinished(this._getValidClosetAddress(), report_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "notifyGenerationFinished", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report));
        return this;
    };
    /**
     * @param {BaseReport| null} report
     *
     */
    ThumbnailManager.prototype.notifyGenerationFailed = function (report) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ThumbnailManager_notifyGenerationFailed(this._getValidClosetAddress(), report_jni);
        Module.deps['TraceUtil'].log("(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "notifyGenerationFailed", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report));
        return this;
    };
    exports.default = ThumbnailManager;
});
