sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/models/local/Connection", "./warnings/TransportWarning"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var SubserviceManager = ltjsEnvironment_1.createModule([50257], EventDispatcher_1.default);
    /**
     * @return {Connection| null}
     */
    SubserviceManager.prototype.getConnection = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SubserviceManager_getConnection(this._getValidClosetAddress());
        //-- Convert abstract(transport::Connection) from jni(size_t) to js(Connection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SubserviceManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getConnection", "-->", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Voucher| null} voucher
     * @return {TransportWarning| null}
     */
    SubserviceManager.prototype.cancel = function (voucher) {
        //-- Convert abstract(transport::Voucher) from js(Voucher) to jni(size_t)
        var voucher_jni = ClosetObject_1.default._getValidClosetAddress(voucher);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SubserviceManager_cancel(this._getValidClosetAddress(), voucher_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SubserviceManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "cancel", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(voucher), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = SubserviceManager;
});
