sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./Voucher", "sas/ltjs/transport/models/local/Folder"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var SharedItemManager = ltjsEnvironment_1.createModule([50257, 50249], EventDispatcher_1.default);
    /**
     * Get all reports shared with me.
     * @return {Voucher| null}
     */
    SharedItemManager.prototype.getSharedWithMe = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SharedItemManager_getSharedWithMe(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SharedItemManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSharedWithMe", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Get all reports I've shared.
     * @return {Voucher| null}
     */
    SharedItemManager.prototype.getSharedByMe = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SharedItemManager_getSharedByMe(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SharedItemManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSharedByMe", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Returns a folder with all the items shared with me, if it exists locally (either from local cache restoration or from a prior call to getHistory().
     * @return {Folder| null}
     */
    SharedItemManager.prototype.getSharedWithMeFolder = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SharedItemManager_getSharedWithMeFolder(this._getValidClosetAddress());
        //-- Convert abstract(transport::Folder) from jni(size_t) to js(Folder)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SharedItemManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSharedWithMeFolder", "-->", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Returns a folder with all the items shared by me, if it exists locally (either from local cache restoration or from a prior call to getHistory().
     * @return {Folder| null}
     */
    SharedItemManager.prototype.getSharedByMeFolder = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SharedItemManager_getSharedByMeFolder(this._getValidClosetAddress());
        //-- Convert abstract(transport::Folder) from jni(size_t) to js(Folder)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SharedItemManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSharedByMeFolder", "-->", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = SharedItemManager;
});
