sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./Voucher", "sas/ltjs/transport/models/local/Folder"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var HistoryManager = ltjsEnvironment_1.createModule([50257, 50148], EventDispatcher_1.default);
    /**
     * Acquires the latest list of recent/history reports. Media: Folder Warnings: .
     * @return {Voucher| null}
     */
    HistoryManager.prototype.getHistory = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_HistoryManager_getHistory(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::HistoryManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getHistory", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Adds the given report to the user's history. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @param {Report| null} report
     * @return {Voucher| null}
     */
    HistoryManager.prototype.addToHistory = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_HistoryManager_addToHistory(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::HistoryManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "addToHistory", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Removes the given report from the user's history. Media: Report. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @param {Report| null} report
     * @return {Voucher| null}
     */
    HistoryManager.prototype.removeFromHistory = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_HistoryManager_removeFromHistory(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::HistoryManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "removeFromHistory", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Clears the entire history for this user. Media: None. Warnings: RESOURCE_NOT_FOUND, SERVICE_FAILURE.
     * @return {Voucher| null}
     */
    HistoryManager.prototype.clearHistory = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_HistoryManager_clearHistory(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::HistoryManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "clearHistory", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Returns the root history folder, if it exists locally (either from local cache restoration or from a prior call to getHistory().
     * @return {Folder| null}
     */
    HistoryManager.prototype.getRootHistoryFolder = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_HistoryManager_getRootHistoryFolder(this._getValidClosetAddress());
        //-- Convert abstract(transport::Folder) from jni(size_t) to js(Folder)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::HistoryManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getRootHistoryFolder", "-->", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = HistoryManager;
});
