sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./Voucher"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var FolderManager = ltjsEnvironment_1.createModule([50257, 50117], EventDispatcher_1.default);
    /**
     * Acquires the contents for the given folder.  If no folder is given, then the root folder's contents are returned.  Note that the given folder is returned immediately as the Voucher's media; callers should anticipate a subsequent update event on the voucher. Media: Folder.  Warnings: INVALID_ARGUMENTS, RESOURCE_NOT_FOUND, LOCAL_RESOURCE_EXPIRED, SERVICE_FAILURE.
     * @param {Folder| null} folder
     * @return {Voucher| null}
     */
    FolderManager.prototype.getFolderContent = function (folder) {
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var folder_jni = ClosetObject_1.default._getValidClosetAddress(folder);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_FolderManager_getFolderContent(this._getValidClosetAddress(), folder_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::FolderManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getFolderContent", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(folder), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = FolderManager;
});
