sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/commons/events/EventDispatcher", "./warnings/TransportWarning"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var DownloadManager = ltjsEnvironment_1.createModule([50090], EventDispatcher_1.default);
    DownloadManager.DOWNLOADS_FINISHED_ABNORMALLY = 60000;
    DownloadManager.DOWNLOAD_CANCELLED = 60001;
    DownloadManager.DOWNLOAD_FAILED = 60002;
    DownloadManager.DOWNLOAD_STARTED = 60003;
    DownloadManager.REPORT_DOWNLOAD_LIMIT_EXCEEDED = 60004;
    DownloadManager.DOWNLOAD_IN_PROGRESS = 60005;
    DownloadManager.INVALID_REPORT = 60006;
    /**
     * @param {Report| null} report
     * @return {TransportWarning| null}
     */
    DownloadManager.prototype.start = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DownloadManager_start(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "start", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Report| null} report
     * @return {TransportWarning| null}
     */
    DownloadManager.prototype.pause = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DownloadManager_pause(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "pause", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Report| null} report
     * @return {TransportWarning| null}
     */
    DownloadManager.prototype.resume = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DownloadManager_resume(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "resume", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Report| null} report
     * @return {TransportWarning| null}
     */
    DownloadManager.prototype.cancel = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DownloadManager_cancel(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "cancel", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    DownloadManager.prototype.pauseAll = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DownloadManager_pauseAll(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "pauseAll", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    DownloadManager.prototype.resumeAll = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DownloadManager_resumeAll(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "resumeAll", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    DownloadManager.prototype.cancelAll = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DownloadManager_cancelAll(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DownloadManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "cancelAll", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    exports.default = DownloadManager;
});
