sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./DeviceInfo", "sas/ltjs/transport/models/media/particles/ReportDataLevel", "sas/ltjs/transport/models/media/particles/CSSAdapter", "sas/ltjs/transport/models/media/particles/ReportImageSize", "sas/ltjs/transport/models/media/particles/Capability"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var DepotConfiguration = ltjsEnvironment_1.createModule([114, 13, 50265, 50081], EventDispatcher_1.default);
    /**
     *
     */
    DepotConfiguration._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_DepotConfiguration_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", "static", "new", "-->", "(transport::DepotConfiguration)", rc);
        return rc;
    };
    /**
     * @return {DeviceInfo| null}
     */
    DepotConfiguration.prototype.getDeviceInfo = function () {
        var deviceInfo_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceInfo");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), deviceInfo_jni);
        //-- Convert abstract(transport::DeviceInfo) from jni(size_t) to js(DeviceInfo)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceInfo", "-->", "(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {DeviceInfo| null} value
     *
     */
    DepotConfiguration.prototype.setDeviceInfo = function (value) {
        //-- Convert abstract(transport::DeviceInfo) from js(DeviceInfo) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var deviceInfo_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceInfo");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, deviceInfo_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceInfo", "(transport::DeviceInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getCacheDirectoryPath = function () {
        var cacheDirectoryPath_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("cacheDirectoryPath");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), cacheDirectoryPath_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#cacheDirectoryPath", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setCacheDirectoryPath = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var cacheDirectoryPath_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("cacheDirectoryPath");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, cacheDirectoryPath_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#cacheDirectoryPath", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getReportSubdirectory = function () {
        var reportSubdirectory_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportSubdirectory");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), reportSubdirectory_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportSubdirectory", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setReportSubdirectory = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var reportSubdirectory_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportSubdirectory");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, reportSubdirectory_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportSubdirectory", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getPrintFilesSubdirectory = function () {
        var printFilesSubdirectory_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("printFilesSubdirectory");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), printFilesSubdirectory_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#printFilesSubdirectory", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setPrintFilesSubdirectory = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var printFilesSubdirectory_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("printFilesSubdirectory");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, printFilesSubdirectory_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#printFilesSubdirectory", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getThumbnailSubdirectory = function () {
        var thumbnailSubdirectory_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("thumbnailSubdirectory");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), thumbnailSubdirectory_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#thumbnailSubdirectory", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setThumbnailSubdirectory = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var thumbnailSubdirectory_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("thumbnailSubdirectory");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, thumbnailSubdirectory_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#thumbnailSubdirectory", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getAvatarSubdirectory = function () {
        var avatarSubdirectory_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("avatarSubdirectory");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), avatarSubdirectory_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#avatarSubdirectory", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setAvatarSubdirectory = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var avatarSubdirectory_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("avatarSubdirectory");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, avatarSubdirectory_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#avatarSubdirectory", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getConnectionSubdirectory = function () {
        var connectionSubdirectory_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connectionSubdirectory");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), connectionSubdirectory_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connectionSubdirectory", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setConnectionSubdirectory = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var connectionSubdirectory_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connectionSubdirectory");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, connectionSubdirectory_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connectionSubdirectory", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getPersistentStorageDirectoryPath = function () {
        var persistentStorageDirectoryPath_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("persistentStorageDirectoryPath");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), persistentStorageDirectoryPath_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#persistentStorageDirectoryPath", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setPersistentStorageDirectoryPath = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var persistentStorageDirectoryPath_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("persistentStorageDirectoryPath");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, persistentStorageDirectoryPath_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#persistentStorageDirectoryPath", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getPasswordKeyChainGroup = function () {
        var passwordKeyChainGroup_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passwordKeyChainGroup");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), passwordKeyChainGroup_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passwordKeyChainGroup", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setPasswordKeyChainGroup = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var passwordKeyChainGroup_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("passwordKeyChainGroup");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, passwordKeyChainGroup_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#passwordKeyChainGroup", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getCredentialKeyChainGroup = function () {
        var credentialKeyChainGroup_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("credentialKeyChainGroup");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), credentialKeyChainGroup_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#credentialKeyChainGroup", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setCredentialKeyChainGroup = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var credentialKeyChainGroup_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("credentialKeyChainGroup");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, credentialKeyChainGroup_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#credentialKeyChainGroup", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getIncludeGuestAccountOnSecureStore = function () {
        var includeGuestAccountOnSecureStore_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("includeGuestAccountOnSecureStore");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), includeGuestAccountOnSecureStore_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#includeGuestAccountOnSecureStore", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setIncludeGuestAccountOnSecureStore = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var includeGuestAccountOnSecureStore_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("includeGuestAccountOnSecureStore");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, includeGuestAccountOnSecureStore_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#includeGuestAccountOnSecureStore", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldAutoConnect = function () {
        var shouldAutoConnect_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoConnect");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldAutoConnect_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoConnect", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldAutoConnect = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldAutoConnect_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoConnect");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldAutoConnect_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoConnect", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldPerformPeriodicDeviceChecks = function () {
        var shouldPerformPeriodicDeviceChecks_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldPerformPeriodicDeviceChecks");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldPerformPeriodicDeviceChecks_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldPerformPeriodicDeviceChecks", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldPerformPeriodicDeviceChecks = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldPerformPeriodicDeviceChecks_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldPerformPeriodicDeviceChecks");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldPerformPeriodicDeviceChecks_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldPerformPeriodicDeviceChecks", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getDeviceCheckFrequency = function () {
        var deviceCheckFrequency_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceCheckFrequency");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), deviceCheckFrequency_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceCheckFrequency", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setDeviceCheckFrequency = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var deviceCheckFrequency_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceCheckFrequency");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, deviceCheckFrequency_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceCheckFrequency", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getDeviceCheckStatusInterval = function () {
        var deviceCheckStatusInterval_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceCheckStatusInterval");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), deviceCheckStatusInterval_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceCheckStatusInterval", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setDeviceCheckStatusInterval = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var deviceCheckStatusInterval_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deviceCheckStatusInterval");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, deviceCheckStatusInterval_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deviceCheckStatusInterval", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldPerformPeriodicReportUpdateChecks = function () {
        var shouldPerformPeriodicReportUpdateChecks_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldPerformPeriodicReportUpdateChecks");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldPerformPeriodicReportUpdateChecks_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldPerformPeriodicReportUpdateChecks", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldPerformPeriodicReportUpdateChecks = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldPerformPeriodicReportUpdateChecks_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldPerformPeriodicReportUpdateChecks");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldPerformPeriodicReportUpdateChecks_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldPerformPeriodicReportUpdateChecks", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldAutoUpdateSubscribedReports = function () {
        var shouldAutoUpdateSubscribedReports_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoUpdateSubscribedReports");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldAutoUpdateSubscribedReports_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoUpdateSubscribedReports", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldAutoUpdateSubscribedReports = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldAutoUpdateSubscribedReports_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoUpdateSubscribedReports");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldAutoUpdateSubscribedReports_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoUpdateSubscribedReports", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getAutoUpdateFrequency = function () {
        var autoUpdateFrequency_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("autoUpdateFrequency");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), autoUpdateFrequency_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#autoUpdateFrequency", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setAutoUpdateFrequency = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var autoUpdateFrequency_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("autoUpdateFrequency");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, autoUpdateFrequency_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#autoUpdateFrequency", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldAutoStartReportAssetDownloads = function () {
        var shouldAutoStartReportAssetDownloads_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoStartReportAssetDownloads");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldAutoStartReportAssetDownloads_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoStartReportAssetDownloads", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldAutoStartReportAssetDownloads = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldAutoStartReportAssetDownloads_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoStartReportAssetDownloads");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldAutoStartReportAssetDownloads_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoStartReportAssetDownloads", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getMaximumNumberOfConcurrentReportDownloads = function () {
        var maximumNumberOfConcurrentReportDownloads_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("maximumNumberOfConcurrentReportDownloads");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), maximumNumberOfConcurrentReportDownloads_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#maximumNumberOfConcurrentReportDownloads", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setMaximumNumberOfConcurrentReportDownloads = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var maximumNumberOfConcurrentReportDownloads_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("maximumNumberOfConcurrentReportDownloads");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, maximumNumberOfConcurrentReportDownloads_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#maximumNumberOfConcurrentReportDownloads", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getMaximumNumberOfConcurrentAssetDownloadsPerReport = function () {
        var maximumNumberOfConcurrentAssetDownloadsPerReport_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("maximumNumberOfConcurrentAssetDownloadsPerReport");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), maximumNumberOfConcurrentAssetDownloadsPerReport_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#maximumNumberOfConcurrentAssetDownloadsPerReport", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setMaximumNumberOfConcurrentAssetDownloadsPerReport = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var maximumNumberOfConcurrentAssetDownloadsPerReport_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("maximumNumberOfConcurrentAssetDownloadsPerReport");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, maximumNumberOfConcurrentAssetDownloadsPerReport_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#maximumNumberOfConcurrentAssetDownloadsPerReport", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {ReportDataLevel}
     */
    DepotConfiguration.prototype.getGenerateReportDataLevel = function () {
        var generateReportDataLevel_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportDataLevel");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), generateReportDataLevel_jni);
        //-- Convert abstract(transport::ReportDataLevel) from jni(int) to js(ReportDataLevel)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportDataLevel", "-->", "(transport::ReportDataLevel::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportDataLevel} value
     *
     */
    DepotConfiguration.prototype.setGenerateReportDataLevel = function (value) {
        //-- Convert abstract(transport::ReportDataLevel) from js(ReportDataLevel) to jni(int)
        var value_jni = value;
        var generateReportDataLevel_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportDataLevel");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, generateReportDataLevel_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportDataLevel", "(transport::ReportDataLevel::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getGenerateReportTimeout = function () {
        var generateReportTimeout_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportTimeout");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), generateReportTimeout_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportTimeout", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setGenerateReportTimeout = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var generateReportTimeout_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportTimeout");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, generateReportTimeout_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportTimeout", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getGenerateReportStatusInterval = function () {
        var generateReportStatusInterval_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportStatusInterval");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), generateReportStatusInterval_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportStatusInterval", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setGenerateReportStatusInterval = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var generateReportStatusInterval_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportStatusInterval");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, generateReportStatusInterval_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportStatusInterval", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getGenerateReportStatusTimeout = function () {
        var generateReportStatusTimeout_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportStatusTimeout");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), generateReportStatusTimeout_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportStatusTimeout", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setGenerateReportStatusTimeout = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var generateReportStatusTimeout_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportStatusTimeout");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, generateReportStatusTimeout_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportStatusTimeout", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getGenerateReportImagesInterval = function () {
        var generateReportImagesInterval_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportImagesInterval");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getFloatProperty(this._getValidClosetAddress(), generateReportImagesInterval_jni);
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportImagesInterval", "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setGenerateReportImagesInterval = function (value) {
        //-- Convert abstract(commons::FLOAT) from js(number) to jni(double)
        var value_jni = value;
        var generateReportImagesInterval_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportImagesInterval");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setFloatProperty(this._getValidClosetAddress(), value_jni, generateReportImagesInterval_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportImagesInterval", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getGenerateReportImagesTimeout = function () {
        var generateReportImagesTimeout_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportImagesTimeout");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getFloatProperty(this._getValidClosetAddress(), generateReportImagesTimeout_jni);
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportImagesTimeout", "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setGenerateReportImagesTimeout = function (value) {
        //-- Convert abstract(commons::FLOAT) from js(number) to jni(double)
        var value_jni = value;
        var generateReportImagesTimeout_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("generateReportImagesTimeout");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setFloatProperty(this._getValidClosetAddress(), value_jni, generateReportImagesTimeout_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#generateReportImagesTimeout", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getReportDataCreateWaitTime = function () {
        var reportDataCreateWaitTime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportDataCreateWaitTime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getFloatProperty(this._getValidClosetAddress(), reportDataCreateWaitTime_jni);
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportDataCreateWaitTime", "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setReportDataCreateWaitTime = function (value) {
        //-- Convert abstract(commons::FLOAT) from js(number) to jni(double)
        var value_jni = value;
        var reportDataCreateWaitTime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportDataCreateWaitTime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setFloatProperty(this._getValidClosetAddress(), value_jni, reportDataCreateWaitTime_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportDataCreateWaitTime", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getReportDataCheckWaitTime = function () {
        var reportDataCheckWaitTime_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportDataCheckWaitTime");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getFloatProperty(this._getValidClosetAddress(), reportDataCheckWaitTime_jni);
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportDataCheckWaitTime", "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setReportDataCheckWaitTime = function (value) {
        //-- Convert abstract(commons::FLOAT) from js(number) to jni(double)
        var value_jni = value;
        var reportDataCheckWaitTime_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportDataCheckWaitTime");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setFloatProperty(this._getValidClosetAddress(), value_jni, reportDataCheckWaitTime_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportDataCheckWaitTime", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldAutoDownloadPrintedReports = function () {
        var shouldAutoDownloadPrintedReports_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoDownloadPrintedReports");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldAutoDownloadPrintedReports_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoDownloadPrintedReports", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldAutoDownloadPrintedReports = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldAutoDownloadPrintedReports_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoDownloadPrintedReports");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldAutoDownloadPrintedReports_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoDownloadPrintedReports", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getExpandedFolderReportCacheLimit = function () {
        var expandedFolderReportCacheLimit_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("expandedFolderReportCacheLimit");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), expandedFolderReportCacheLimit_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#expandedFolderReportCacheLimit", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setExpandedFolderReportCacheLimit = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var expandedFolderReportCacheLimit_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("expandedFolderReportCacheLimit");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, expandedFolderReportCacheLimit_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#expandedFolderReportCacheLimit", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getSupportsTethered = function () {
        var supportsTethered_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportsTethered");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), supportsTethered_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportsTethered", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setSupportsTethered = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var supportsTethered_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportsTethered");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, supportsTethered_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportsTethered", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {CSSAdapter}
     */
    DepotConfiguration.prototype.getCssAdapter = function () {
        var cssAdapter_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("cssAdapter");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), cssAdapter_jni);
        //-- Convert abstract(transport::CSSAdapter) from jni(int) to js(CSSAdapter)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#cssAdapter", "-->", "(transport::CSSAdapter::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {CSSAdapter} value
     *
     */
    DepotConfiguration.prototype.setCssAdapter = function (value) {
        //-- Convert abstract(transport::CSSAdapter) from js(CSSAdapter) to jni(int)
        var value_jni = value;
        var cssAdapter_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("cssAdapter");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, cssAdapter_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#cssAdapter", "(transport::CSSAdapter::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getUseHighContrastReportStyle = function () {
        var useHighContrastReportStyle_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useHighContrastReportStyle");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), useHighContrastReportStyle_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useHighContrastReportStyle", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setUseHighContrastReportStyle = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var useHighContrastReportStyle_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("useHighContrastReportStyle");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, useHighContrastReportStyle_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#useHighContrastReportStyle", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldAutoCleanupCollectionBasedReportSubscriptions = function () {
        var shouldAutoCleanupCollectionBasedReportSubscriptions_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoCleanupCollectionBasedReportSubscriptions");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldAutoCleanupCollectionBasedReportSubscriptions_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoCleanupCollectionBasedReportSubscriptions", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldAutoCleanupCollectionBasedReportSubscriptions = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldAutoCleanupCollectionBasedReportSubscriptions_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoCleanupCollectionBasedReportSubscriptions");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldAutoCleanupCollectionBasedReportSubscriptions_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoCleanupCollectionBasedReportSubscriptions", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldEnforceOfflineLimit = function () {
        var shouldEnforceOfflineLimit_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldEnforceOfflineLimit");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldEnforceOfflineLimit_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldEnforceOfflineLimit", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldEnforceOfflineLimit = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldEnforceOfflineLimit_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldEnforceOfflineLimit");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldEnforceOfflineLimit_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldEnforceOfflineLimit", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getSupportsTransportServerLogging = function () {
        var supportsTransportServerLogging_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportsTransportServerLogging");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), supportsTransportServerLogging_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportsTransportServerLogging", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setSupportsTransportServerLogging = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var supportsTransportServerLogging_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("supportsTransportServerLogging");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, supportsTransportServerLogging_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#supportsTransportServerLogging", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldAutoRefreshFavorites = function () {
        var shouldAutoRefreshFavorites_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoRefreshFavorites");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldAutoRefreshFavorites_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoRefreshFavorites", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldAutoRefreshFavorites = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldAutoRefreshFavorites_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoRefreshFavorites");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldAutoRefreshFavorites_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoRefreshFavorites", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldAutoRefreshHistory = function () {
        var shouldAutoRefreshHistory_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoRefreshHistory");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldAutoRefreshHistory_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoRefreshHistory", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldAutoRefreshHistory = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldAutoRefreshHistory_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoRefreshHistory");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldAutoRefreshHistory_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoRefreshHistory", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldAutoRefreshCollections = function () {
        var shouldAutoRefreshCollections_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoRefreshCollections");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldAutoRefreshCollections_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoRefreshCollections", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldAutoRefreshCollections = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldAutoRefreshCollections_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldAutoRefreshCollections");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldAutoRefreshCollections_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldAutoRefreshCollections", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getPortfolioRefreshFrequency = function () {
        var portfolioRefreshFrequency_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("portfolioRefreshFrequency");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), portfolioRefreshFrequency_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#portfolioRefreshFrequency", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setPortfolioRefreshFrequency = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var portfolioRefreshFrequency_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("portfolioRefreshFrequency");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, portfolioRefreshFrequency_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#portfolioRefreshFrequency", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getMaximumHistoryEntries = function () {
        var maximumHistoryEntries_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("maximumHistoryEntries");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), maximumHistoryEntries_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#maximumHistoryEntries", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setMaximumHistoryEntries = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var maximumHistoryEntries_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("maximumHistoryEntries");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, maximumHistoryEntries_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#maximumHistoryEntries", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getMaximumShareEntries = function () {
        var maximumShareEntries_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("maximumShareEntries");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), maximumShareEntries_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#maximumShareEntries", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setMaximumShareEntries = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var maximumShareEntries_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("maximumShareEntries");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, maximumShareEntries_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#maximumShareEntries", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldDoConnectionKeepAlive = function () {
        var shouldDoConnectionKeepAlive_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldDoConnectionKeepAlive");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldDoConnectionKeepAlive_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldDoConnectionKeepAlive", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldDoConnectionKeepAlive = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldDoConnectionKeepAlive_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldDoConnectionKeepAlive");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldDoConnectionKeepAlive_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldDoConnectionKeepAlive", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getConnectionKeepAliveFrequency = function () {
        var connectionKeepAliveFrequency_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connectionKeepAliveFrequency");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), connectionKeepAliveFrequency_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connectionKeepAliveFrequency", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setConnectionKeepAliveFrequency = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var connectionKeepAliveFrequency_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("connectionKeepAliveFrequency");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, connectionKeepAliveFrequency_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#connectionKeepAliveFrequency", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getClientid = function () {
        var clientid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("clientid");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), clientid_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#clientid", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setClientid = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var clientid_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("clientid");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, clientid_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#clientid", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getUserCacheSize = function () {
        var userCacheSize_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userCacheSize");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), userCacheSize_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userCacheSize", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setUserCacheSize = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var userCacheSize_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("userCacheSize");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, userCacheSize_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#userCacheSize", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {string| null}
     */
    DepotConfiguration.prototype.getDownloadedReportImageSubdirectory = function () {
        var downloadedReportImageSubdirectory_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadedReportImageSubdirectory");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getStringProperty(this._getValidClosetAddress(), downloadedReportImageSubdirectory_jni);
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadedReportImageSubdirectory", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @param {string| null} value
     *
     */
    DepotConfiguration.prototype.setDownloadedReportImageSubdirectory = function (value) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var value_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(value);
        var downloadedReportImageSubdirectory_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("downloadedReportImageSubdirectory");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setStringProperty(this._getValidClosetAddress(), value_jni, downloadedReportImageSubdirectory_name_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(value_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#downloadedReportImageSubdirectory", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getReportImageCacheMaxFileCount = function () {
        var reportImageCacheMaxFileCount_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImageCacheMaxFileCount");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), reportImageCacheMaxFileCount_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImageCacheMaxFileCount", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setReportImageCacheMaxFileCount = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var reportImageCacheMaxFileCount_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImageCacheMaxFileCount");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, reportImageCacheMaxFileCount_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImageCacheMaxFileCount", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getReportImageCacheMaxTotalSize = function () {
        var reportImageCacheMaxTotalSize_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImageCacheMaxTotalSize");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), reportImageCacheMaxTotalSize_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImageCacheMaxTotalSize", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setReportImageCacheMaxTotalSize = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var reportImageCacheMaxTotalSize_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImageCacheMaxTotalSize");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, reportImageCacheMaxTotalSize_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImageCacheMaxTotalSize", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldGeneratePreviewsOnDownload = function () {
        var shouldGeneratePreviewsOnDownload_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldGeneratePreviewsOnDownload");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldGeneratePreviewsOnDownload_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldGeneratePreviewsOnDownload", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldGeneratePreviewsOnDownload = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldGeneratePreviewsOnDownload_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldGeneratePreviewsOnDownload");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldGeneratePreviewsOnDownload_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldGeneratePreviewsOnDownload", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldDownloadReportImagesOnSubscribe = function () {
        var shouldDownloadReportImagesOnSubscribe_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldDownloadReportImagesOnSubscribe");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldDownloadReportImagesOnSubscribe_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldDownloadReportImagesOnSubscribe", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldDownloadReportImagesOnSubscribe = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldDownloadReportImagesOnSubscribe_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldDownloadReportImagesOnSubscribe");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldDownloadReportImagesOnSubscribe_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldDownloadReportImagesOnSubscribe", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {ReportImageSize}
     */
    DepotConfiguration.prototype.getReportImageDefaultSize = function () {
        var reportImageDefaultSize_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImageDefaultSize");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), reportImageDefaultSize_jni);
        //-- Convert abstract(transport::ReportImageSize) from jni(int) to js(ReportImageSize)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImageDefaultSize", "-->", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportImageSize} value
     *
     */
    DepotConfiguration.prototype.setReportImageDefaultSize = function (value) {
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var value_jni = value;
        var reportImageDefaultSize_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportImageDefaultSize");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, reportImageDefaultSize_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportImageDefaultSize", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {ReportImageSize}
     */
    DepotConfiguration.prototype.getReportSectionImageDefaultSize = function () {
        var reportSectionImageDefaultSize_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportSectionImageDefaultSize");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), reportSectionImageDefaultSize_jni);
        //-- Convert abstract(transport::ReportImageSize) from jni(int) to js(ReportImageSize)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportSectionImageDefaultSize", "-->", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {ReportImageSize} value
     *
     */
    DepotConfiguration.prototype.setReportSectionImageDefaultSize = function (value) {
        //-- Convert abstract(transport::ReportImageSize) from js(ReportImageSize) to jni(int)
        var value_jni = value;
        var reportSectionImageDefaultSize_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("reportSectionImageDefaultSize");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, reportSectionImageDefaultSize_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#reportSectionImageDefaultSize", "(transport::ReportImageSize::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldDownloadAvatarsForComments = function () {
        var shouldDownloadAvatarsForComments_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldDownloadAvatarsForComments");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldDownloadAvatarsForComments_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldDownloadAvatarsForComments", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldDownloadAvatarsForComments = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldDownloadAvatarsForComments_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldDownloadAvatarsForComments");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldDownloadAvatarsForComments_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldDownloadAvatarsForComments", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {number}
     */
    DepotConfiguration.prototype.getAvatarRefreshPeriod = function () {
        var avatarRefreshPeriod_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("avatarRefreshPeriod");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), avatarRefreshPeriod_jni);
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#avatarRefreshPeriod", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @param {number} value
     *
     */
    DepotConfiguration.prototype.setAvatarRefreshPeriod = function (value) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var value_jni = value;
        var avatarRefreshPeriod_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("avatarRefreshPeriod");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, avatarRefreshPeriod_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#avatarRefreshPeriod", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(value));
        return this;
    };
    /**
     * @return {Capability}
     */
    DepotConfiguration.prototype.getCapabilityToCheckForAccess = function () {
        var capabilityToCheckForAccess_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("capabilityToCheckForAccess");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getIntProperty(this._getValidClosetAddress(), capabilityToCheckForAccess_jni);
        //-- Convert abstract(transport::Capability) from jni(int) to js(Capability)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#capabilityToCheckForAccess", "-->", "(transport::Capability::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {Capability} value
     *
     */
    DepotConfiguration.prototype.setCapabilityToCheckForAccess = function (value) {
        //-- Convert abstract(transport::Capability) from js(Capability) to jni(int)
        var value_jni = value;
        var capabilityToCheckForAccess_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("capabilityToCheckForAccess");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setIntProperty(this._getValidClosetAddress(), value_jni, capabilityToCheckForAccess_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#capabilityToCheckForAccess", "(transport::Capability::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getAllowFutureServers = function () {
        var allowFutureServers_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("allowFutureServers");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), allowFutureServers_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#allowFutureServers", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setAllowFutureServers = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var allowFutureServers_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("allowFutureServers");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, allowFutureServers_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#allowFutureServers", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getWipePasswords = function () {
        var wipePasswords_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("wipePasswords");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), wipePasswords_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#wipePasswords", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setWipePasswords = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var wipePasswords_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("wipePasswords");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, wipePasswords_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#wipePasswords", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    /**
     * @return {boolean}
     */
    DepotConfiguration.prototype.getShouldGetTextSummaryOnSubscribe = function () {
        var shouldGetTextSummaryOnSubscribe_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldGetTextSummaryOnSubscribe");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getBooleanProperty(this._getValidClosetAddress(), shouldGetTextSummaryOnSubscribe_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldGetTextSummaryOnSubscribe", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {boolean} value
     *
     */
    DepotConfiguration.prototype.setShouldGetTextSummaryOnSubscribe = function (value) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var value_jni = !!value;
        var shouldGetTextSummaryOnSubscribe_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("shouldGetTextSummaryOnSubscribe");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setBooleanProperty(this._getValidClosetAddress(), value_jni, shouldGetTextSummaryOnSubscribe_name_jni);
        Module.deps['TraceUtil'].log("(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#shouldGetTextSummaryOnSubscribe", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(value));
        return this;
    };
    exports.default = DepotConfiguration;
});
