sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/commons/events/EventDispatcher", "./warnings/TransportWarning", "sas/ltjs/transport/models/local/DepotStatus", "./CASManager", "./CollectionsManager", "./ConnectionManager", "./FolderManager", "./FavoritesManager", "./HistoryManager", "./ReportManager", "./ReportViewerNLUManager", "./SharedItemManager", "./TextTemplatesManager", "./ThumbnailManager", "./DownloadManager", "./MuxManager", "sas/ltjs/transport/models/local/Connection", "sas/ltjs/transport/models/local/Report", "./Voucher"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Depot = ltjsEnvironment_1.createModule([50080], EventDispatcher_1.default);
    Depot.DEPOT_CONNECTION_ESRI_PORTAL_NOT_AVAILABLE = 60042;
    Depot.DEPOT_CONNECTION_ESRI_PORTAL_NOT_REQUIRED = 60043;
    Depot.DEPOT_CONNECTION_ESRI_PORTAL_NO_CREDENTIALS = 60044;
    Depot.DEPOT_CONNECTION_ESRI_PORTAL_BAD_CREDENTIALS = 60045;
    Depot.DEPOT_CONNECTION_ESRI_PORTAL_HAS_TOKEN = 60046;
    Depot.DEPOT_CONNECTION_ESRI_DISABLED = 60047;
    Depot.DEPOT_CONNECTION_ESRI_NO_CREDENTIALS = 60048;
    Depot.DEPOT_CONNECTION_ESRI_NO_CAPABILITY = 60049;
    Depot.DEPOT_CONNECTION_ESRI_LOGIN_SUCCESS = 60050;
    Depot.DEPOT_CONNECTION_ESRI_LOGIN_FAILURE = 60051;
    Depot.DEPOT_CONNECTION_REQUIRES_AUTHENTICATION = 60052;
    Depot.DEPOT_CONNECTION_KEEP_ALIVE_COMPLETE = 60053;
    Depot.DEPOT_CONNECTION_BACKLIST_WHITELIST = 60054;
    Depot.DEPOT_CONNECTION_OFFLINE_LIMIT_EXCEEDED = 60055;
    Depot.DEPOT_CONNECTION_AUTHENTICATION_FAILED = 60056;
    Depot.DEPOT_CONNECTION_CHANGED = 60057;
    Depot.DEPOT_CONNECTION_REMOVED = 60058;
    Depot.DEPOT_CONNECTION_ADDED = 60059;
    Depot.DEPOT_RESUMED = 60060;
    Depot.DEPOT_QUIESCED = 60061;
    Depot.DEPOT_IDLE = 60062;
    Depot.DEPOT_BUSY = 60063;
    /**
     * @param {DepotConfiguration| null} configuration
     *
     */
    Depot._create = function (configuration) {
        //-- Convert abstract(transport::DepotConfiguration) from js(DepotConfiguration) to jni(size_t)
        var configuration_jni = ClosetObject_1.default._getValidClosetAddress(configuration);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_create(configuration_jni);
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Depot)", "static", "new", "(transport::DepotConfiguration)", Module.deps['TraceUtil'].traceConversions.convertModel(configuration), "-->", "(transport::Depot)", rc);
        return rc;
    };
    /**
     *
     */
    Depot.prototype.updateTimers = function () {
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_updateTimers(this._getValidClosetAddress());
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "updateTimers");
        return this;
    };
    /**
     * @param {number} frequency
     *
     */
    Depot.prototype.changeAutoUpdateFrequency = function (frequency) {
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var frequency_jni = frequency;
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_changeAutoUpdateFrequency(this._getValidClosetAddress(), frequency_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "changeAutoUpdateFrequency", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(frequency));
        return this;
    };
    /**
     * @param {boolean} useHighContrastReportStyle
     *
     */
    Depot.prototype.setUseHighContrastReportStyle = function (useHighContrastReportStyle) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var useHighContrastReportStyle_jni = !!useHighContrastReportStyle;
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_setUseHighContrastReportStyle(this._getValidClosetAddress(), useHighContrastReportStyle_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "setUseHighContrastReportStyle", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(useHighContrastReportStyle));
        return this;
    };
    /**
     * @return {TransportWarning| null}
     */
    Depot.prototype.commit = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_commit(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "commit", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    Depot.prototype.quiesce = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_quiesce(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "quiesce", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    Depot.prototype.quiesceWhenDone = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_quiesceWhenDone(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "quiesceWhenDone", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    Depot.prototype.resume = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_resume(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "resume", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    Depot.prototype.shutdown = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_shutdown(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "shutdown", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {DepotStatus}
     */
    Depot.prototype.getStatus = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getStatus(this._getValidClosetAddress());
        //-- Convert abstract(transport::DepotStatus) from jni(int) to js(DepotStatus)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getStatus", "-->", "(transport::DepotStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @param {boolean} debug
     *
     */
    Depot.prototype.setDebug = function (debug) {
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var debug_jni = !!debug;
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_setDebug(this._getValidClosetAddress(), debug_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "setDebug", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(debug));
        return this;
    };
    /**
     * @return {boolean}
     */
    Depot.prototype.isDebugEnabled = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_isDebugEnabled(this._getValidClosetAddress());
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isDebugEnabled", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {CASManager| null}
     */
    Depot.prototype.getCASManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getCASManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::CASManager) from jni(size_t) to js(CASManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getCASManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::CASManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {CollectionsManager| null}
     */
    Depot.prototype.getCollectionsManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getCollectionsManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::CollectionsManager) from jni(size_t) to js(CollectionsManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getCollectionsManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::CollectionsManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {ConnectionManager| null}
     */
    Depot.prototype.getConnectionManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getConnectionManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::ConnectionManager) from jni(size_t) to js(ConnectionManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getConnectionManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {FolderManager| null}
     */
    Depot.prototype.getFolderManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getFolderManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::FolderManager) from jni(size_t) to js(FolderManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getFolderManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::FolderManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {FavoritesManager| null}
     */
    Depot.prototype.getFavoritesManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getFavoritesManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::FavoritesManager) from jni(size_t) to js(FavoritesManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getFavoritesManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::FavoritesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {HistoryManager| null}
     */
    Depot.prototype.getHistoryManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getHistoryManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::HistoryManager) from jni(size_t) to js(HistoryManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getHistoryManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::HistoryManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {ReportManager| null}
     */
    Depot.prototype.getReportManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getReportManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::ReportManager) from jni(size_t) to js(ReportManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReportManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::ReportManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {ReportViewerNLUManager| null}
     */
    Depot.prototype.getReportViewerNLUManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getReportViewerNLUManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::ReportViewerNLUManager) from jni(size_t) to js(ReportViewerNLUManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getReportViewerNLUManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::ReportViewerNLUManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {SharedItemManager| null}
     */
    Depot.prototype.getSharedItemManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getSharedItemManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::SharedItemManager) from jni(size_t) to js(SharedItemManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSharedItemManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::SharedItemManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {TextTemplatesManager| null}
     */
    Depot.prototype.getTextTemplatesManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getTextTemplatesManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::TextTemplatesManager) from jni(size_t) to js(TextTemplatesManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getTextTemplatesManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::TextTemplatesManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {ThumbnailManager| null}
     */
    Depot.prototype.getThumbnailManager = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getThumbnailManager(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::ThumbnailManager) from jni(size_t) to js(ThumbnailManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getThumbnailManager", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::ThumbnailManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {DownloadManager| null}
     */
    Depot.prototype.getDownloadManager = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getDownloadManager(this._getValidClosetAddress());
        //-- Convert abstract(transport::DownloadManager) from jni(size_t) to js(DownloadManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getDownloadManager", "-->", "(transport::DownloadManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {MuxManager| null}
     */
    Depot.prototype.getMuxManager = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getMuxManager(this._getValidClosetAddress());
        //-- Convert abstract(transport::MuxManager) from jni(size_t) to js(MuxManager)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getMuxManager", "-->", "(transport::MuxManager)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {Array.<Connection| null> | null}
     */
    Depot.prototype.getAllConnections = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getAllConnections(this._getValidClosetAddress());
        //-- Convert abstract(<transport::Connection>) from jni(size_t) to js(Connection)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getAllConnections", "-->", "(ARRAY<transport::Connection>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {string| null} host
     * @param {number} port
     * @return {Array.<Connection| null> | null}
     */
    Depot.prototype.getConnections = function (host, port) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var host_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(host);
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var port_jni = port;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getConnections(this._getValidClosetAddress(), host_jni, port_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(host_jni);
        //-- Convert abstract(<transport::Connection>) from jni(size_t) to js(Connection)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getConnections", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(host), "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(port), "-->", "(ARRAY<transport::Connection>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {string| null} host
     * @param {number} port
     * @param {string| null} userId
     * @param {boolean} useGuestCredentials
     * @return {Connection| null}
     */
    Depot.prototype._getConnection_snsb = function (host, port, userId, useGuestCredentials) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var host_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(host);
        //-- Convert abstract(commons::INT) from js(number) to jni(int)
        var port_jni = port;
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var userId_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(userId);
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var useGuestCredentials_jni = !!useGuestCredentials;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getConnection_snsb(this._getValidClosetAddress(), host_jni, port_jni, userId_jni, useGuestCredentials_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(host_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(userId_jni);
        //-- Convert abstract(transport::Connection) from jni(size_t) to js(Connection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getConnection", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(host), "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(port), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(userId), "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(useGuestCredentials), "-->", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {string| null} uuid
     * @return {Connection| null}
     */
    Depot.prototype._getConnection_s = function (uuid) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var uuid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(uuid);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getConnection_s(this._getValidClosetAddress(), uuid_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(uuid_jni);
        //-- Convert abstract(transport::Connection) from jni(size_t) to js(Connection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getConnection", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(uuid), "-->", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {TransportWarning| null}
     */
    Depot.prototype.verifyConnection = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_verifyConnection(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "verifyConnection", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {TransportWarning| null}
     */
    Depot.prototype.addConnection = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_addConnection(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "addConnection", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {TransportWarning| null}
     */
    Depot.prototype.removeConnection = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_removeConnection(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "removeConnection", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    Depot.prototype.removeAllConnections = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_removeAllConnections(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "removeAllConnections", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @param {string| null} newPassword
     * @return {TransportWarning| null}
     */
    Depot.prototype.editConnectionPassword = function (connection, newPassword) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var newPassword_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(newPassword);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_editConnectionPassword(this._getValidClosetAddress(), connection_jni, newPassword_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(newPassword_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "editConnectionPassword", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(newPassword), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @param {string| null} newDescription
     * @return {TransportWarning| null}
     */
    Depot.prototype.editConnectionDescription = function (connection, newDescription) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var newDescription_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(newDescription);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_editConnectionDescription(this._getValidClosetAddress(), connection_jni, newDescription_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(newDescription_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "editConnectionDescription", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(newDescription), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {boolean}
     */
    Depot.prototype.isPasscodeRequired = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_isPasscodeRequired(this._getValidClosetAddress());
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isPasscodeRequired", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @return {number}
     */
    Depot.prototype.getPasscodeTimeout = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getPasscodeTimeout(this._getValidClosetAddress());
        //-- Convert abstract(commons::FLOAT) from jni(double) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getPasscodeTimeout", "-->", "(commons::FLOAT)", Module.deps['TraceUtil'].traceConversions.convertFloat(rc));
        return rc;
    };
    /**
     * @return {number}
     */
    Depot.prototype.getPasscodeAttempts = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getPasscodeAttempts(this._getValidClosetAddress());
        //-- Convert abstract(commons::INT) from jni(int) to js(number)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getPasscodeAttempts", "-->", "(commons::INT)", Module.deps['TraceUtil'].traceConversions.convertInt(rc));
        return rc;
    };
    /**
     * @return {Array.<Report| null> | null}
     */
    Depot.prototype._getAllSubscribedReports_v = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getAllSubscribedReports_v(this._getValidClosetAddress());
        //-- Convert abstract(<transport::Report>) from jni(size_t) to js(Report)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getAllSubscribedReports", "-->", "(ARRAY<transport::Report>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {Array.<Report| null> | null}
     */
    Depot.prototype._getAllSubscribedReports_o = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getAllSubscribedReports_o(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(<transport::Report>) from jni(size_t) to js(Report)
        var rc = WrappableCloset_1.getWrapperArray(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getAllSubscribedReports", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(ARRAY<transport::Report>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertModel));
        return rc;
    };
    /**
     * @param {string| null} uuid
     * @return {Report| null}
     */
    Depot.prototype._getSubscribedReport_s = function (uuid) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var uuid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(uuid);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getSubscribedReport_s(this._getValidClosetAddress(), uuid_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(uuid_jni);
        //-- Convert abstract(transport::Report) from jni(size_t) to js(Report)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSubscribedReport", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(uuid), "-->", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @param {string| null} location
     * @return {Report| null}
     */
    Depot.prototype._getSubscribedReport_os = function (connection, location) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_getSubscribedReport_os(this._getValidClosetAddress(), connection_jni, location_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        //-- Convert abstract(transport::Report) from jni(size_t) to js(Report)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getSubscribedReport", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "-->", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Report| null} report
     * @return {TransportWarning| null}
     */
    Depot.prototype.removeReport = function (report) {
        //-- Convert abstract(transport::Report) from js(Report) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_removeReport(this._getValidClosetAddress(), report_jni);
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "removeReport", "(transport::Report)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @return {TransportWarning| null}
     */
    Depot.prototype.removeAllReports = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_removeAllReports(this._getValidClosetAddress());
        //-- Convert abstract(transport::TransportWarning) from jni(size_t) to js(TransportWarning)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "removeAllReports", "-->", "(transport::TransportWarning)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {BaseReport| null} report
     * @param {string| null} sectionName
     * @return {Voucher| null}
     */
    Depot.prototype.logEmailSent = function (report, sectionName) {
        //-- Convert abstract(transport::BaseReport) from js(BaseReport) to jni(size_t)
        var report_jni = ClosetObject_1.default._getValidClosetAddress(report);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var sectionName_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(sectionName);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_logEmailSent(this._getValidClosetAddress(), report_jni, sectionName_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(sectionName_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "logEmailSent", "(transport::BaseReport)", Module.deps['TraceUtil'].traceConversions.convertModel(report), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(sectionName), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {Voucher| null}
     */
    Depot.prototype.refreshHistory = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_refreshHistory(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "refreshHistory", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {Voucher| null}
     */
    Depot.prototype.refreshRootFavorites = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_refreshRootFavorites(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "refreshRootFavorites", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {Voucher| null}
     */
    Depot.prototype.refreshAllFavorites = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_refreshAllFavorites(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "refreshAllFavorites", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {Voucher| null}
     */
    Depot.prototype.refreshReportFavoriteFlags = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_refreshReportFavoriteFlags(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "refreshReportFavoriteFlags", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Connection| null} connection
     * @return {Voucher| null}
     */
    Depot.prototype.refreshCollections = function (connection) {
        //-- Convert abstract(transport::Connection) from js(Connection) to jni(size_t)
        var connection_jni = ClosetObject_1.default._getValidClosetAddress(connection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_Depot_refreshCollections(this._getValidClosetAddress(), connection_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::Depot)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "refreshCollections", "(transport::Connection)", Module.deps['TraceUtil'].traceConversions.convertModel(connection), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    Depot.prototype.getConnection = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_getConnection", Array.prototype.slice.call(arguments));
    };
    Depot.prototype.getSubscribedReport = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_getSubscribedReport", Array.prototype.slice.call(arguments));
    };
    Depot.prototype.getAllSubscribedReports = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_getAllSubscribedReports", Array.prototype.slice.call(arguments));
    };
    exports.default = Depot;
});
