sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "sas/ltjs/transport/models/media/particles/LogonStatus", "sas/ltjs/transport/models/media/particles/EsriLogonStatus", "sas/ltjs/transport/models/media/particles/EsriPortalLogonStatus", "./Voucher", "sas/ltjs/commons/maps/MapConnectionInfo"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var ConnectionManager = ltjsEnvironment_1.createModule([50257, 50070], EventDispatcher_1.default);
    /**
     * Looks up the password in the secure store and returns it. Convenience method for apps so all the steps to do this are in one place.
     * @return {string| null}
     */
    ConnectionManager.prototype.getStoredPassword = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getStoredPassword(this._getValidClosetAddress());
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getStoredPassword", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @return {LogonStatus}
     */
    ConnectionManager.prototype.getLogonStatus = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getLogonStatus(this._getValidClosetAddress());
        //-- Convert abstract(transport::LogonStatus) from jni(int) to js(LogonStatus)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getLogonStatus", "-->", "(transport::LogonStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @return {EsriLogonStatus}
     */
    ConnectionManager.prototype.getEsriLogonStatus = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getEsriLogonStatus(this._getValidClosetAddress());
        //-- Convert abstract(transport::EsriLogonStatus) from jni(int) to js(EsriLogonStatus)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getEsriLogonStatus", "-->", "(transport::EsriLogonStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * @return {EsriPortalLogonStatus}
     */
    ConnectionManager.prototype.getEsriPortalLogonStatus = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getEsriPortalLogonStatus(this._getValidClosetAddress());
        //-- Convert abstract(transport::EsriPortalLogonStatus) from jni(int) to js(EsriPortalLogonStatus)
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getEsriPortalLogonStatus", "-->", "(transport::EsriPortalLogonStatus::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(rc));
        return rc;
    };
    /**
     * Acquires the server configuration information for this connection. Media: ServerConfig.  Warnings: .
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.getServerConfig = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getServerConfig(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getServerConfig", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Issues a server call to keep the connection alive.
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.keepAlive = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_keepAlive(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "keepAlive", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Establishes an authenticated session for this connection and issues a getUserCapabilities call to retrieve the user/capability information.  Note that client applications must handle logons and logoffs manually for connections that have not been added to the depot (ie. during the initial connection setup process).  However, once added, this should be handled automatically by the depot as long as auto-connect is enabled (ie. shouldAutoConnect='true').  Media: UserInfo. Warnings: .
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.logon = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_logon(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "logon", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Ends the current authenticated session for this connection. Note that client applications must handle logons and logoffs manually for connections that have not been added to the depot (ie. during the initial connection setup process).  However, once added, this should be handled automatically by the depot as long as auto-connect is enabled (ie. shouldAutoConnect='true').  Media: None. Warnings: .
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.logoff = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_logoff(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "logoff", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Sets the authentication token, updates the connection status to logged on, and issues a getUserCapabilities call to initialize the Transport Services connection and retrieve associated user/capability information.  The token is expected to be a TGT issued by the SAS Logon Manager.  This API is intended to be used by web clients that are managing their own sessions (ie. shouldAutoConnect='false') and logging on independently through the SAS Logon Manager.  Media: UserInfo  Warnings: .
     * @param {string| null} token
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.initializeSession = function (token) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var token_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(token);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_initializeSession(this._getValidClosetAddress(), token_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(token_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "initializeSession", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(token), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Clears the authentication token for the connection and updates the connection status to logged off.  This API is intended to be used by web clients that are managing their own sessions (ie. shouldAutoConnect='false') and logging off independently through the SAS Logon Manager.  Media: None.  Warnings: .
     *
     */
    ConnectionManager.prototype.clearSessionToken = function () {
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_clearSessionToken(this._getValidClosetAddress());
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "clearSessionToken");
        return this;
    };
    /**
     * Downloads the logo for this connection.  The logo is saved under the 'connectionSubdirectory' in the 'cacheDirectoryPath' specified in the depot configuration.  It is saved as filename 'logo' under the subfolder matching the uuid of the connection - ie. (cacheDirectoryPath)/(connectionSubdirectory)/(uuid)/logo.  Media: FileLocation.  Warnings: .
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.getLogo = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getLogo(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getLogo", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Adds the provided strings to the VATS logs. Media: None. Warnings: .
     * @param {string| null} message
     * @return {Voucher| null}
     */
    ConnectionManager.prototype._log_s = function (message) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var message_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(message);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_log_s(this._getValidClosetAddress(), message_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(message_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "log", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(message), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Adds the provided strings to the VATS logs. Media: None. Warnings: .
     * @param {Array.<string| null> | null} message
     * @return {Voucher| null}
     */
    ConnectionManager.prototype._log_o = function (message) {
        //-- Convert abstract(<commons::STRING>) from js(string) to jni(size_t)
        var message_jni = ltjsEnvironment_1.ltjsModule.convertStringArrayToC(message);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_log_o(this._getValidClosetAddress(), message_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releaseAllPrimitives(message_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "log", "(ARRAY<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(message, Module.deps['TraceUtil'].traceConversions.convertString), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Capability} capability
     * @return {boolean}
     */
    ConnectionManager.prototype.hasCapability = function (capability) {
        //-- Convert abstract(transport::Capability) from js(Capability) to jni(int)
        var capability_jni = capability;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_hasCapability(this._getValidClosetAddress(), capability_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "hasCapability", "(transport::Capability::type)", Module.deps['TraceUtil'].traceConversions.convertEnum(capability), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ConnectionManager.prototype.getAuthorizationHeaders = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getAuthorizationHeaders(this._getValidClosetAddress());
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getAuthorizationHeaders", "-->", "(ARRAY<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @return {Array.<string| null> | null}
     */
    ConnectionManager.prototype.getCookieHeaders = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getCookieHeaders(this._getValidClosetAddress());
        //-- Convert abstract(<commons::STRING>) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringArrayFromC(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getCookieHeaders", "-->", "(ARRAY<commons::STRING>)", Module.deps['TraceUtil'].traceConversions.convertArray(rc, Module.deps['TraceUtil'].traceConversions.convertString));
        return rc;
    };
    /**
     * @return {boolean}
     */
    ConnectionManager.prototype.isPersonalizationEnabled = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_isPersonalizationEnabled(this._getValidClosetAddress());
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isPersonalizationEnabled", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * @return {MapConnectionInfo| null}
     */
    ConnectionManager.prototype.getMapConnectionInfo = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getMapConnectionInfo(this._getValidClosetAddress());
        //-- Convert abstract(commons::MapConnectionInfo) from jni(size_t) to js(MapConnectionInfo)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getMapConnectionInfo", "-->", "(commons::MapConnectionInfo)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Sets the userid and password for esri premium login.
     * @param {string| null} userid
     * @param {string| null} password
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.setEsriCredentials = function (userid, password) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var userid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(userid);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var password_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(password);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_setEsriCredentials(this._getValidClosetAddress(), userid_jni, password_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(userid_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(password_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "setEsriCredentials", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(userid), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(password), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Gets the userid for esri premium login.
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.getEsriCredentials = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getEsriCredentials(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getEsriCredentials", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Sets the userid and password for esri portal login.
     * @param {string| null} userid
     * @param {string| null} password
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.setEsriPortalCredentials = function (userid, password) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var userid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(userid);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var password_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(password);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_setEsriPortalCredentials(this._getValidClosetAddress(), userid_jni, password_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(userid_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(password_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "setEsriPortalCredentials", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(userid), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(password), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Gets the userid for esri portal login.
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.getEsriPortalCredentials = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getEsriPortalCredentials(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getEsriPortalCredentials", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Request esri premium token. This is only needed if credentials are updated outside of Transport-Portable, i.e. ReportViewer
     *
     */
    ConnectionManager.prototype.requestEsriPremiumToken = function () {
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_requestEsriPremiumToken(this._getValidClosetAddress());
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "requestEsriPremiumToken");
        return this;
    };
    /**
     * Request esri portal token. This is only needed if credentials are updated outside of Transport-Portable, i.e. ReportViewer
     *
     */
    ConnectionManager.prototype.requestEsriPortalToken = function () {
        ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_requestEsriPortalToken(this._getValidClosetAddress());
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "requestEsriPortalToken");
        return this;
    };
    /**
     * Download the avatar for a given user. May immediately succeed if the avatar is already downloaded.
     * @param {string| null} userid
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.getUserAvatar = function (userid) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var userid_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(userid);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_getUserAvatar(this._getValidClosetAddress(), userid_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(userid_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getUserAvatar", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(userid), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Download a file to a specific location.
     * @param {string| null} url
     * @param {string| null} destinationPath
     * @return {Voucher| null}
     */
    ConnectionManager.prototype.downloadFile = function (url, destinationPath) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var url_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(url);
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var destinationPath_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(destinationPath);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_ConnectionManager_downloadFile(this._getValidClosetAddress(), url_jni, destinationPath_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(url_jni);
        ltjsEnvironment_1.ltjsModule.releasePrimitive(destinationPath_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::ConnectionManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "downloadFile", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(url), "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(destinationPath), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    ConnectionManager.prototype.log = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_log", Array.prototype.slice.call(arguments));
    };
    exports.default = ConnectionManager;
});
