sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "./SubserviceManager", "./Voucher", "sas/ltjs/transport/models/local/Folder"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CollectionsManager = ltjsEnvironment_1.createModule([50257, 50060], EventDispatcher_1.default);
    /**
     * Acquires the list of Hub Collections registered for the current user.  This includes the user's 'My Collections' as well as any shared Collections that were published by the Hub Administrator.  It does not include unpublished System collections. Media: Folder. Warnings: SERVICE_FAILURE.
     * @return {Voucher| null}
     */
    CollectionsManager.prototype.getCollections = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CollectionsManager_getCollections(this._getValidClosetAddress());
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionsManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getCollections", "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Acquires the contents for the given folder.  Note that the given folder is returned immediately as the Voucher's media; callers should anticipate a subsequent update event on the voucher. Media: Folder.  Warnings: INVALID_ARGUMENTS, RESOURCE_NOT_FOUND, LOCAL_RESOURCE_EXPIRED, SERVICE_FAILURE.
     * @param {Folder| null} folder
     * @return {Voucher| null}
     */
    CollectionsManager.prototype.getFolderContent = function (folder) {
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var folder_jni = ClosetObject_1.default._getValidClosetAddress(folder);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CollectionsManager_getFolderContent(this._getValidClosetAddress(), folder_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionsManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getFolderContent", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(folder), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Adds the Collection to the Depot and subscribes to all associated reports. The folder is required to be a FavoritesFolder or FavoritesGroup.  Media: SubscribedCollection.  Media: SubscribedCollection.  Warnings: INVALID_ARGUMENTS, RESOURCE_NOT_FOUND, LOCAL_RESOURCE_EXPIRED, SERVICE_FAILURE.
     * @param {Folder| null} folder
     * @return {Voucher| null}
     */
    CollectionsManager.prototype._subscribeToCollection_o = function (folder) {
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var folder_jni = ClosetObject_1.default._getValidClosetAddress(folder);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CollectionsManager_subscribeToCollection_o(this._getValidClosetAddress(), folder_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionsManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "subscribeToCollection", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(folder), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Adds the Collection to the Depot and subscribes to all associated reports.  The location is required to be a FavoritesFolder or FavoritesGroup.  Media: SubscribedCollection.  Warnings: INVALID_ARGUMENTS, RESOURCE_NOT_FOUND, LOCAL_RESOURCE_EXPIRED, SERVICE_FAILURE.
     * @param {string| null} location
     * @return {Voucher| null}
     */
    CollectionsManager.prototype._subscribeToCollection_s = function (location) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var location_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(location);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CollectionsManager_subscribeToCollection_s(this._getValidClosetAddress(), location_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(location_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionsManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "subscribeToCollection", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(location), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * Retrieves the current list of reports associated with the given collection - subscribes to any newly identified reports and (if the depot is configure to AutoCleanupCollectionBasedReportSubscriptions) removes any reports that were automatically subscribes based on this collection subscription.  If the depot is configured to auto-update, then this function will be initated from the Depot on a periodic basis and should not need to be called directly from the client application.  Media: SubscribedCollection. Warnings: .
     * @param {SubscribedCollection| null} collection
     * @return {Voucher| null}
     */
    CollectionsManager.prototype.checkForUpdates = function (collection) {
        //-- Convert abstract(transport::SubscribedCollection) from js(SubscribedCollection) to jni(size_t)
        var collection_jni = ClosetObject_1.default._getValidClosetAddress(collection);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CollectionsManager_checkForUpdates(this._getValidClosetAddress(), collection_jni);
        //-- Convert abstract(transport::Voucher) from jni(size_t) to js(Voucher)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionsManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "checkForUpdates", "(transport::SubscribedCollection)", Module.deps['TraceUtil'].traceConversions.convertModel(collection), "-->", "(transport::Voucher)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Folder| null} folder
     * @return {boolean}
     */
    CollectionsManager.prototype.isValidFolder = function (folder) {
        //-- Convert abstract(transport::Folder) from js(Folder) to jni(size_t)
        var folder_jni = ClosetObject_1.default._getValidClosetAddress(folder);
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CollectionsManager_isValidFolder(this._getValidClosetAddress(), folder_jni);
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::CollectionsManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "isValidFolder", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(folder), "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    /**
     * Returns the root collections folder, if it exists locally (either from local cache restoration or from a prior call to getFavorites().
     * @return {Folder| null}
     */
    CollectionsManager.prototype.getRootCollectionsFolder = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CollectionsManager_getRootCollectionsFolder(this._getValidClosetAddress());
        //-- Convert abstract(transport::Folder) from jni(size_t) to js(Folder)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionsManager)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getRootCollectionsFolder", "-->", "(transport::Folder)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    CollectionsManager.prototype.subscribeToCollection = function ( /*arguments*/) {
        return ClosetObject_1.default.callOverloadedFunction(this, "_subscribeToCollection", Array.prototype.slice.call(arguments));
    };
    exports.default = CollectionsManager;
});
