sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/commons/events/EventDispatcher"], function (require, exports, ltjsEnvironment_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var SortDescriptor = ltjsEnvironment_1.createModule([50254], EventDispatcher_1.default);
    /**
     * @param {string| null} property
     * @param {boolean} ascending
     *
     */
    SortDescriptor._create = function (property, ascending) {
        //-- Convert abstract(commons::STRING) from js(string) to jni(size_t)
        var property_jni = ltjsEnvironment_1.ltjsModule.convertStringToC(property);
        //-- Convert abstract(commons::BOOLEAN) from js(boolean) to jni(bool)
        var ascending_jni = !!ascending;
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SortDescriptor_create(property_jni, ascending_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(property_jni);
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::SortDescriptor)", "static", "new", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(property), "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(ascending), "-->", "(transport::SortDescriptor)", rc);
        return rc;
    };
    /**
     * @return {string| null}
     */
    SortDescriptor.prototype.getProperty = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SortDescriptor_getProperty(this._getValidClosetAddress());
        //-- Convert abstract(commons::STRING) from jni(size_t) to js(string)
        var rc = ltjsEnvironment_1.ltjsModule.convertStringFromC(rc_jni);
        //-- Release temporary closet objects
        ltjsEnvironment_1.ltjsModule.releasePrimitive(rc_jni);
        Module.deps['TraceUtil'].log("(transport::SortDescriptor)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getProperty", "-->", "(commons::STRING)", Module.deps['TraceUtil'].traceConversions.convertString(rc));
        return rc;
    };
    /**
     * @return {boolean}
     */
    SortDescriptor.prototype.getAscending = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_SortDescriptor_getAscending(this._getValidClosetAddress());
        //-- Convert abstract(commons::BOOLEAN) from jni(bool) to js(boolean)
        var rc = !!rc_jni;
        Module.deps['TraceUtil'].log("(transport::SortDescriptor)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "getAscending", "-->", "(commons::BOOLEAN)", Module.deps['TraceUtil'].traceConversions.convertBool(rc));
        return rc;
    };
    exports.default = SortDescriptor;
});
