sas.ltjs.define(["require", "exports", "sas/ltjs/commons/ltjsEnvironment", "sas/ltjs/commons/WrappableCloset", "sas/ltjs/commons/ClosetObject", "sas/ltjs/commons/events/EventDispatcher", "sas/ltjs/transport/lib", "sas/ltjs/transport/models/TransportModel", "./Collection"], function (require, exports, ltjsEnvironment_1, WrappableCloset_1, ClosetObject_1, EventDispatcher_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CollectionDelta = ltjsEnvironment_1.createModule([114, 13, 50265, 50058], EventDispatcher_1.default);
    /**
     *
     */
    CollectionDelta._create = function () {
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_transport_CollectionDelta_create();
        //-- Convert abstract(commons::VOID) from jni(void) to js()
        var rc = rc_jni;
        Module.deps['TraceUtil'].log("(transport::CollectionDelta)", "static", "new", "-->", "(transport::CollectionDelta)", rc);
        return rc;
    };
    /**
     * @return {Collection| null}
     */
    CollectionDelta.prototype.getAddition = function () {
        var addition_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("addition");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), addition_jni);
        //-- Convert abstract(transport::Collection) from jni(size_t) to js(Collection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionDelta)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#addition", "-->", "(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Collection| null} value
     *
     */
    CollectionDelta.prototype.setAddition = function (value) {
        //-- Convert abstract(transport::Collection) from js(Collection) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var addition_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("addition");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, addition_name_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionDelta)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#addition", "(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    /**
     * @return {Collection| null}
     */
    CollectionDelta.prototype.getDeletion = function () {
        var deletion_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deletion");
        var rc_jni = ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_getWrappableProperty(this._getValidClosetAddress(), deletion_jni);
        //-- Convert abstract(transport::Collection) from jni(size_t) to js(Collection)
        var rc = WrappableCloset_1.getWrapper(rc_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionDelta)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deletion", "-->", "(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(rc));
        return rc;
    };
    /**
     * @param {Collection| null} value
     *
     */
    CollectionDelta.prototype.setDeletion = function (value) {
        //-- Convert abstract(transport::Collection) from js(Collection) to jni(size_t)
        var value_jni = ClosetObject_1.default._getValidClosetAddress(value);
        var deletion_name_jni = ltjsEnvironment_1.ltjsModule.convertStringToC("deletion");
        ltjsEnvironment_1.ltjsModule.asm._ltjs_commons_Closet_setWrappableProperty(this._getValidClosetAddress(), value_jni, deletion_name_jni);
        Module.deps['TraceUtil'].log("(transport::CollectionDelta)", Module.deps['TraceUtil'].traceConversions.convertModel(this), "#deletion", "(transport::Collection)", Module.deps['TraceUtil'].traceConversions.convertModel(value));
        return this;
    };
    exports.default = CollectionDelta;
});
