<%@ page language="java" contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://www.sas.com/taglib/sas-html" prefix="sas-html" %>

<%
    boolean applicationSwitcherEnabled = true;    
    try{
        com.sas.commons.rest.cas.TicketingRestTemplate restTemplate = new com.sas.commons.rest.cas.TicketingRestTemplate("/SASVisualAnalyticsHub");
        String url = org.springframework.web.servlet.support.ServletUriComponentsBuilder.fromContextPath(request).build().toUriString();
        restTemplate.getForObject(url + "/../SASVisualAnalyticsHub", String.class);
    }catch(Exception e){
        applicationSwitcherEnabled = false;
    }
    String asId = request.getParameter("asId");
    if(!"RuleManager".equals(asId) && !"DecisionBuilder".equals(asId) && !"ModelManager".equals(asId)){
		asId = "";
	}
    String wsWorkspaceCategory = request.getParameter("wsWorkspaceCategory");
    String applicationName = "SAS\u00AE Decision Management";
 %>

<sas-html:Application
        applicationName="<%=applicationName%>"
        applicationId="decisionmanager"
        jsViewClass="sas.decisionmgr.Application"
        applicationSwitcherEnabled="<%=applicationSwitcherEnabled %>"
        configFile="config.js">

	<sas-html:config-property name="sas.external" value="{}" quote="false" />
    <sas-html:config-property name="sas.external.asId" value="<%=asId%>" />
    <sas-html:config-property name="sas.external.wsWorkspaceCategory" value="<%=wsWorkspaceCategory%>" />
	<!-- MM --> 
    <sas-html:config-property name="sas.modelmanager" value="{}" quote="false" />
    
    <sas-html:config-property name="sas.brm" value="{}" quote="false" />
    <sas-html:config-property name="sas.brm.serviceRegUrl" value="/SASBusinessRulesManagerWeb/rest/" />
    <sas-html:config-property name="sas.dcm" value="{}" quote="false" />
    <sas-html:config-property name="sas.dcm.serviceRegUrl" value="/SASDecisionManagerCommon/rest/" />
    <sas-html:config-property name="sas.mm" value="{}" quote="false" />
    <sas-html:config-property name="sas.mm.serviceRegUrl" value="/SASModelManagerJavaServices/sasui/" />
    <sas-html:config-property name="sas.mm.restServiceRegUrl" value="/SASModelManagerJavaServices/rest/" />
    <sas-html:config-property name="sas.dcmsasui" value="{}" quote="false" />
    <sas-html:config-property name="sas.dcmsasui.serviceRegUrl" value="/SASDecisionManagerCommon/sasui/" />
    <sas-html:config-property name="sas.workflowadmin" value="{}" quote="false" />
    <sas-html:config-property name="sas.workflowadmin.serviceRegUrl" value="/SASDecisionManagerCommon/sasui/" />
    
    <sas-html:config-property name="sas.userId" value="<%=request.getRemoteUser()%>" />
    <sas-html:config-property name="sas.wipClient" value="{}" quote="false" />
    <sas-html:config-property name="sas.wipClient.brmConfUrl" value="/SASWIPClientAccess/rest/applications/Business Rules Manager Web 3.3" />
    <!-- DCM -->     
	 <sas-html:config-property name="sas.decisionmanager" value="{}" quote="false" />
    
    <sas-html:config-property name="sas.decisionmanager.help" value="{}" quote="false" />

	<sas-html:config-property name="sas.decisionmanager.help.externalLink" value="http://support.sas.com/documentation/onlinedoc/edm/index.html#edm33"/>
	
    <sas-html:config-property name="sas.decisionbuilder" value="{}" quote="false" />
    
    <sas-html:config-property name="sas.decisionbuilder.commons" value="{}" quote="false" />
    <sas-html:config-property name="sas.decisionbuilder.commons.defaultMessageTitle" value="SAS Decision Builder"/>
	
</sas-html:Application>
