/*
 * Decompiled with CFR 0.152.
 */
package com.dataflux.proxy.ws;

import com.dataflux.java.proxy.PipelineTransform;
import com.dataflux.proxy.ws.WebServiceClientCallbacks;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;

public class WebServiceParameter {
    protected boolean mIsInput = false;
    protected boolean mIsXML = true;
    private ClassLoader mLoader = null;
    protected String mXPath = null;
    protected Boolean mXPathIsAttribute = false;
    protected int mXPathStepCount = 0;
    protected QName[] mXPathSteps = null;
    protected int[] mXPathStepsPosition = null;
    protected InputStream mInput = null;
    protected PipelineTransform mPipeline = null;
    protected OutputStream mOutput = null;
    protected volatile Throwable mThrowable = null;

    public void addPipeline(PipelineTransform pipeline) {
        if (null != this.mPipeline) {
            if (this.mIsInput) {
                pipeline.appendTransform(this.mPipeline);
                this.mPipeline = pipeline;
            } else {
                this.mPipeline.appendTransform(pipeline);
            }
        } else {
            this.mPipeline = pipeline;
        }
    }

    public Throwable getException() {
        return this.mThrowable;
    }

    public InputStream getInputStream() {
        this.mPipeline.start();
        this.mInput = this.mPipeline.getInputStream();
        return this.mInput;
    }

    public boolean getIsXML() {
        return this.mIsXML;
    }

    public String getXPath() {
        return this.mXPath;
    }

    public Boolean getXPathIsAttribute() {
        return this.mXPathIsAttribute;
    }

    public QName getXPathStep(int i) {
        return this.mXPathSteps[i];
    }

    public int getXPathStepCount() {
        return this.mXPathStepCount;
    }

    public int getXPathStepPosition(int i) {
        return this.mXPathStepsPosition[i];
    }

    public OutputStream getOutputStream() {
        if (null != this.mPipeline) {
            this.mPipeline.start();
            return this.mPipeline.getOutputStream();
        }
        return this.mOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolve(WebServiceClientCallbacks cb) {
        String step;
        try {
            int hit;
            int start = 0;
            while (0 <= (hit = this.mXPath.indexOf(47, start))) {
                ++this.mXPathStepCount;
                start = hit + 1;
            }
            this.mXPathSteps = new QName[this.mXPathStepCount];
            this.mXPathStepsPosition = new int[this.mXPathStepCount];
            start = 1;
            for (int i = 0; i < this.mXPathStepCount; ++i) {
                String name;
                hit = this.mXPath.indexOf(47, start);
                if (0 > hit) {
                    step = this.mXPath.substring(start);
                } else {
                    step = this.mXPath.substring(start, hit);
                    start = hit + 1;
                }
                int position = 1;
                if ('@' == step.charAt(0)) {
                    this.mXPathIsAttribute = true;
                    step = step.substring(1);
                } else {
                    hit = step.indexOf(91);
                    if (0 <= hit) {
                        int end = step.indexOf(93, ++hit);
                        position = Integer.parseInt(step.substring(hit, end));
                        step = step.substring(0, hit - 1);
                    }
                }
                String uri = null;
                hit = step.indexOf(58);
                if (0 < hit) {
                    String prefix = step.substring(0, hit);
                    name = step.substring(hit + 1);
                    uri = cb.getNamespace(prefix);
                } else {
                    name = step;
                    uri = null;
                }
                this.mXPathSteps[i] = new QName(uri, name);
                this.mXPathStepsPosition[i] = position - 1;
            }
            String string = null;
            return string;
        }
        finally {
            step = null;
        }
    }

    public void setIsXML(boolean isXML) {
        this.mIsXML = isXML;
    }

    public boolean setProperty(String property, String value) {
        return false;
    }

    public void stop() {
    }

    public String toString() {
        if (null != this.mPipeline && (this.mIsInput ? this.mPipeline.getClass().getSimpleName().equals("StringInputPT") || this.mPipeline.getClass().getSimpleName().equals("FileInputPT") : this.mPipeline.getClass().getSimpleName().equals("StringOutputPT"))) {
            return this.mPipeline.toString();
        }
        return null;
    }

    protected WebServiceParameter(ClassLoader cl, String XPath, boolean input) {
        this.mLoader = cl;
        this.mXPath = XPath;
        this.mIsInput = input;
    }
}

