/*
 * Decompiled with CFR 0.152.
 */
package com.dataflux.proxy.ws;

import com.dataflux.proxy.ws.WebServiceParameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.axiom.AxiomSoapMessage;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.http.HttpComponentsConnection;

public class ResponseMessageCallback
implements WebServiceMessageCallback {
    private ArrayList<WebServiceParameter> mParms = null;
    private SoapVersion mSoapVersion = null;
    Logger mLogger = LoggerFactory.getLogger((String)"DF.WebService.Response");
    protected HttpHeaders mHttpHeaders = null;

    public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
        AxiomSoapMessage axiomSoapMessage = (AxiomSoapMessage)message;
        SOAPMessage soapMessage = axiomSoapMessage.getAxiomMessage();
        try {
            HttpResponse httpResponse;
            Header[] headers;
            HttpComponentsConnection connection;
            TransportContext context;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug(soapMessage.getSOAPEnvelope().toString());
            }
            if (null == this.mSoapVersion) {
                this.mSoapVersion = SoapVersion.SOAP_11;
            }
            if (null != this.mParms && 0 < this.mParms.size()) {
                for (int i = 0; i < this.mParms.size(); ++i) {
                    this.serializeEntity(this.mParms.get(i), 1, (OMElement)soapMessage.getSOAPEnvelope());
                }
            }
            if (null != (context = TransportContextHolder.getTransportContext()) && null != (connection = (HttpComponentsConnection)TransportContextHolder.getTransportContext().getConnection()) && null != (headers = (httpResponse = connection.getHttpResponse()).getAllHeaders())) {
                this.mHttpHeaders = new HttpHeaders();
                for (Header header : headers) {
                    this.mLogger.debug("Capturing response header: '{}'='{}'", (Object)header.getName(), (Object)header.getValue());
                    this.mHttpHeaders.add(header.getName(), header.getValue());
                }
            }
        }
        catch (Throwable throwable) {
            throw new TransformerException(throwable);
        }
        finally {
            axiomSoapMessage = null;
            soapMessage = null;
        }
    }

    public HttpHeaders getHeaders() {
        return this.mHttpHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeEntity(WebServiceParameter parm, int step, OMElement elem) throws IOException, XMLStreamException {
        try {
            if (null == elem) {
                return;
            }
            int steps = parm.getXPathStepCount();
            if (step == steps) {
                if (null == elem.getFirstElement()) {
                    OMNode node = elem.getFirstOMChild();
                    if (null != node) {
                        if (4 == node.getType() && ((OMText)node).isBinary()) {
                            OMText text = (OMText)node;
                            DataHandler dh = (DataHandler)text.getDataHandler();
                            dh.writeTo(parm.getOutputStream());
                        } else {
                            String value = elem.getText();
                            if (null != value) {
                                parm.getOutputStream().write(value.getBytes("utf-8"));
                            }
                        }
                    }
                } else {
                    elem.serialize(parm.getOutputStream());
                }
                return;
            }
            if (parm.getXPathIsAttribute().booleanValue() && steps == step + 1) {
                QName qName = parm.getXPathStep(step);
                String value = elem.getAttributeValue(qName);
                if (null != value) {
                    parm.getOutputStream().write(value.getBytes("utf-8"));
                }
                return;
            }
            QName qName = parm.getXPathStep(step);
            int position = parm.getXPathStepPosition(step);
            if (0 < position) {
                Iterator children = elem.getChildrenWithName(qName);
                if (null != children) {
                    int stride = 0;
                    while (children.hasNext()) {
                        Object object = children.next();
                        if (position == stride) {
                            if (object instanceof OMElement) {
                                OMElement child = (OMElement)object;
                                this.serializeEntity(parm, step + 1, child);
                            }
                            break;
                        }
                        ++stride;
                    }
                }
            } else {
                this.serializeEntity(parm, step + 1, elem.getFirstChildWithName(qName));
            }
            return;
        }
        finally {
            Object child = null;
            Object children = null;
            elem = null;
            Object object = null;
            parm = null;
            Object qName = null;
            Object value = null;
        }
    }

    public ResponseMessageCallback(ArrayList<WebServiceParameter> outputParms, SoapVersion soapVersion) {
        this.mParms = outputParms;
        this.mSoapVersion = soapVersion;
    }
}

