/*
 * Decompiled with CFR 0.152.
 */
package com.dataflux.proxy.ws;

import com.dataflux.proxy.ws.MultiReader;
import com.dataflux.proxy.ws.WebServiceParameter;
import com.dataflux.wlp.RowSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.axiom.AxiomSoapMessage;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.http.HttpComponentsConnection;

public class RequestMessageCallback
implements WebServiceMessageCallback {
    protected String mAction = null;
    protected OMElement mRequestTemplate = null;
    protected SoapVersion mSoapVersion = null;
    private ArrayList<WebServiceParameter> mParms;
    private RowSet mHeaders = null;
    Logger mLogger = LoggerFactory.getLogger((String)"DF.WebService.Request");

    public void doWithMessage(WebServiceMessage message) throws IOException, TransformerException {
        OMElement body;
        SOAPHeader soapHeader;
        OMElement header;
        OMNamespace ns;
        Iterator iNS;
        OMNamespace templateNS;
        Iterator iTNS;
        int i;
        AxiomSoapMessage axiomSoapMessage = (AxiomSoapMessage)message;
        SOAPMessage soapMessage = axiomSoapMessage.getAxiomMessage();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        if (null == this.mSoapVersion) {
            this.mSoapVersion = SoapVersion.SOAP_11;
        }
        if (null != this.mAction) {
            ((SoapMessage)message).setSoapAction(this.mAction);
        }
        if (null != this.mHeaders) {
            HttpComponentsConnection connection = (HttpComponentsConnection)TransportContextHolder.getTransportContext().getConnection();
            HttpPost httpPost = connection.getHttpPost();
            for (i = 0; i < this.mHeaders.getRowCount(); ++i) {
                httpPost.addHeader((String)this.mHeaders.getObject(i, 0), (String)this.mHeaders.getObject(i, 1));
            }
        }
        try {
            iTNS = this.mRequestTemplate.getAllDeclaredNamespaces();
            while (iTNS.hasNext()) {
                templateNS = (OMNamespace)iTNS.next();
                iNS = soapEnvelope.getAllDeclaredNamespaces();
                ns = null;
                while (iNS.hasNext() && !(ns = (OMNamespace)iNS.next()).getNamespaceURI().equals(templateNS.getNamespaceURI())) {
                    ns = null;
                }
                if (null != ns) continue;
                soapEnvelope.declareNamespace(templateNS);
            }
            header = this.mRequestTemplate.getFirstChildWithName(this.mSoapVersion.getHeaderName());
            if (null != header) {
                soapHeader = soapEnvelope.getHeader();
                iTNS = header.getAllDeclaredNamespaces();
                while (iTNS.hasNext()) {
                    templateNS = (OMNamespace)iTNS.next();
                    iNS = soapHeader.getAllDeclaredNamespaces();
                    ns = null;
                    while (iNS.hasNext() && !(ns = (OMNamespace)iNS.next()).getNamespaceURI().equals(templateNS)) {
                        ns = null;
                    }
                    if (null != ns) continue;
                    soapHeader.declareNamespace(templateNS);
                }
                Iterator iH = header.getChildElements();
                while (iH.hasNext()) {
                    OMElement clonedElem = ((OMElement)iH.next()).cloneOMElement();
                    soapHeader.addChild((OMNode)clonedElem);
                }
            }
            body = this.mRequestTemplate.getFirstChildWithName(this.mSoapVersion.getBodyName());
            iTNS = body.getAllDeclaredNamespaces();
            while (iTNS.hasNext()) {
                templateNS = (OMNamespace)iTNS.next();
                iNS = soapBody.getAllDeclaredNamespaces();
                ns = null;
                while (iNS.hasNext() && !(ns = (OMNamespace)iNS.next()).getNamespaceURI().equals(templateNS)) {
                    ns = null;
                }
                if (null != ns) continue;
                soapBody.declareNamespace(templateNS);
            }
            soapBody.addChild((OMNode)body.getFirstElement());
            if (null != this.mParms && 0 < this.mParms.size()) {
                for (i = 0; i < this.mParms.size(); ++i) {
                    this.injectData(this.mParms.get(i), 1, (OMElement)soapEnvelope);
                }
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug(soapEnvelope.toString());
            }
        }
        catch (Throwable throwable) {
            throw new TransformerException(throwable);
        }
        finally {
            axiomSoapMessage = null;
            body = null;
            header = null;
            iNS = null;
            iTNS = null;
            ns = null;
            soapBody = null;
            soapEnvelope = null;
            soapHeader = null;
            soapMessage = null;
            templateNS = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OMNamespace findNamespace(OMElement elem, String uri) {
        OMNamespace ns;
        Iterator iNS;
        try {
            while (null != elem) {
                iNS = elem.getAllDeclaredNamespaces();
                if (null != iNS) {
                    while (iNS.hasNext()) {
                        ns = (OMNamespace)iNS.next();
                        if (!uri.equals(ns.getNamespaceURI())) continue;
                        OMNamespace oMNamespace = ns;
                        return oMNamespace;
                    }
                }
                if (elem.getParent() instanceof OMElement) {
                    elem = (OMElement)elem.getParent();
                    continue;
                }
                elem = null;
            }
        }
        finally {
            iNS = null;
            ns = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectData(WebServiceParameter parm, int step, OMElement elem) throws XMLStreamException {
        OMNode node;
        Iterator children;
        OMAttribute elemAttr;
        OMAttribute attr;
        Iterator attrs;
        OMNamespace childNS;
        OMElement child;
        OMElement bodyDouble;
        OMXMLParserWrapper omParserWrapper;
        XMLStreamReader xmlReader;
        BufferedReader bufferedReader;
        MultiReader multiReader;
        Reader[] readers;
        StringReader postfix;
        StringReader prefix;
        InputStreamReader inputStreamReader;
        InputStream inputStream;
        String postfixString;
        String prefixString;
        OMNamespace ns;
        String value;
        QName qName;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        try {
            int steps = parm.getXPathStepCount();
            if (step == steps) {
                qName = parm.getXPathStep(step - 1);
                value = qName.getNamespaceURI();
                ns = null != value ? this.findNamespace(elem, value) : null;
                if (parm.getIsXML()) {
                    prefixString = "<";
                    postfixString = "</";
                    if (null != ns && null != (value = ns.getPrefix())) {
                        prefixString = prefixString.concat(ns.getPrefix() + ":");
                        postfixString = postfixString.concat(ns.getPrefix() + ":");
                    }
                    prefixString = prefixString.concat(qName.getLocalPart());
                    postfixString = postfixString.concat(qName.getLocalPart() + ">");
                    if (null != ns) {
                        value = ns.getPrefix();
                        prefixString = null != value ? prefixString.concat(" xmlns:" + value) : prefixString.concat(" xmlns");
                        prefixString = prefixString.concat("='" + ns.getNamespaceURI() + "'");
                    }
                    prefixString = prefixString.concat(">");
                    int readerCt = 2;
                    inputStream = parm.getInputStream();
                    if (null != inputStream) {
                        inputStreamReader = new InputStreamReader(inputStream);
                        ++readerCt;
                    } else {
                        inputStreamReader = null;
                    }
                    prefix = new StringReader(prefixString);
                    postfix = new StringReader(postfixString);
                    readers = new Reader[readerCt];
                    int i = 0;
                    readers[i++] = prefix;
                    prefix = null;
                    if (null != inputStreamReader) {
                        readers[i++] = inputStreamReader;
                        inputStreamReader = null;
                    }
                    readers[i++] = postfix;
                    postfix = null;
                    multiReader = new MultiReader(readers);
                    bufferedReader = new BufferedReader(multiReader);
                    xmlReader = XMLInputFactory.newInstance().createXMLStreamReader(bufferedReader);
                    omParserWrapper = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)xmlReader);
                    bodyDouble = omParserWrapper.getDocumentElement();
                    bodyDouble.build();
                    for (i = 0; i < readerCt; ++i) {
                        readers[i] = null;
                    }
                } else {
                    bodyDouble = omFactory.createOMElement(qName);
                    bodyDouble.setText(parm.toString());
                    bodyDouble.build();
                }
                if (null != (child = bodyDouble.getFirstElement())) {
                    childNS = child.getNamespace();
                    if (null == ns && null != childNS || null != ns && null == childNS || null != ns && false == ns.getNamespaceURI().equals(childNS.getNamespaceURI()) || !child.getLocalName().equals(qName.getLocalPart())) {
                        child = bodyDouble;
                    }
                }
                if (null == child) {
                    child = bodyDouble;
                }
                if (null != (attrs = child.getAllAttributes())) {
                    while (attrs.hasNext()) {
                        attr = (OMAttribute)attrs.next();
                        elemAttr = elem.getAttribute(attr.getQName());
                        if (null == elemAttr) {
                            attrs.remove();
                            elem.addAttribute(attr);
                            continue;
                        }
                        elemAttr.setAttributeType(attr.getAttributeType());
                        elemAttr.setAttributeValue(attr.getAttributeValue());
                    }
                }
                if (null != (children = child.getChildren())) {
                    while (children.hasNext()) {
                        node = (OMNode)children.next();
                        children.remove();
                        elem.addChild(node);
                    }
                }
                return;
            }
            if (parm.getXPathIsAttribute().booleanValue() && steps == step + 1) {
                QName qName2 = parm.getXPathStep(step);
                OMAttribute attr2 = elem.getAttribute(qName2);
                if (null == attr2) {
                    String value2 = qName2.getNamespaceURI();
                    OMNamespace ns2 = null != value2 ? this.findNamespace(elem, value2) : null;
                    attr2 = elem.addAttribute(qName2.getLocalPart(), null, ns2);
                }
                attr2.setAttributeValue(parm.toString());
                return;
            }
            QName qName3 = parm.getXPathStep(step);
            OMElement child2 = null;
            Iterator children2 = elem.getChildrenWithName(qName3);
            if (null != children2) {
                int position = parm.getXPathStepPosition(step);
                int stride = 0;
                while (children2.hasNext()) {
                    Object object = children2.next();
                    if (stride == position) {
                        if (!(object instanceof OMElement)) break;
                        child2 = (OMElement)object;
                        break;
                    }
                    child2 = null;
                    ++stride;
                }
            }
            if (null == child2) {
                child2 = elem.getOMFactory().createOMElement(qName3);
                elem.addChild((OMNode)child2);
            }
            this.injectData(parm, step + 1, child2);
            return;
        }
        finally {
            attr = null;
            attrs = null;
            bodyDouble = null;
            bufferedReader = null;
            child = null;
            childNS = null;
            children = null;
            elem = null;
            elemAttr = null;
            inputStream = null;
            inputStreamReader = null;
            multiReader = null;
            ns = null;
            node = null;
            Object object = null;
            omFactory = null;
            omParserWrapper = null;
            postfix = null;
            postfixString = null;
            prefix = null;
            prefixString = null;
            qName = null;
            readers = null;
            value = null;
            xmlReader = null;
        }
    }

    public RequestMessageCallback(ArrayList<WebServiceParameter> inputParms, OMElement requestTemplate, SoapVersion soapVersion, RowSet headers) {
        this.mParms = inputParms;
        this.mRequestTemplate = requestTemplate;
        this.mSoapVersion = soapVersion;
        this.mHeaders = headers;
    }

    public void setAction(String action) {
        this.mAction = action;
    }
}

