/*
 * Decompiled with CFR 0.152.
 */
package com.dataflux.proxy.ws;

import com.dataflux.java.proxy.FileInputPT;
import com.dataflux.java.proxy.FileOutputPT;
import com.dataflux.java.proxy.JavaProxyClass;
import com.dataflux.java.proxy.JavaProxyClientCallbacks;
import com.dataflux.java.proxy.JavaProxyMethod;
import com.dataflux.java.proxy.JavaProxyVM;
import com.dataflux.java.proxy.PathToStream;
import com.dataflux.java.proxy.PipelineTransform;
import com.dataflux.java.proxy.StringInputPT;
import com.dataflux.java.proxy.StringOutputPT;
import com.dataflux.proxy.ws.BuildInfo;
import com.dataflux.proxy.ws.InvokeImplementation;
import com.dataflux.proxy.ws.RequestMessageCallback;
import com.dataflux.proxy.ws.ResponseMessageCallback;
import com.dataflux.proxy.ws.WSDLDiscovery;
import com.dataflux.proxy.ws.WebServiceClientCallbacks;
import com.dataflux.proxy.ws.WebServiceParameter;
import com.dataflux.wlp.Request;
import com.dataflux.wlp.Response;
import com.dataflux.wlp.RowSet;
import com.dataflux.wlp.WLPBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.http.Consts;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.springframework.beans.BeansException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.WebServiceIOException;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapFault;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapVersion;
import org.springframework.ws.soap.axiom.AxiomSoapMessageFactory;
import org.springframework.ws.soap.security.wss4j.Wss4jSecurityInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.HttpComponentsMessageSender;

public class WebServiceClientJPC
extends JavaProxyClass
implements WebServiceClientCallbacks {
    protected Properties mProperties = null;
    protected RowSet mHeaders = null;
    protected HttpHeaders mHttpHeaders = null;
    protected Boolean mSecured = false;
    protected ArrayList<WebServiceParameter> mInputParms = null;
    protected InvokeImplementation mInvokeImpl = null;
    private ArrayList<OMNamespace> mNamespaces = null;
    protected ArrayList<WebServiceParameter> mOutputParms = null;
    protected ArrayList<String> mDigestURIs = null;
    private volatile Boolean mStop = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHttpClient(Properties props, String prefix, String configDefault) throws BeansException, IOException {
        CloseableHttpClient httpClient;
        FileSystemXmlApplicationContext applicationContext = null;
        Object credentials = null;
        BasicCredentialsProvider credentialsProvider = null;
        int port = 0;
        Registry authSchemeRegistry = null;
        PathToStream p2sHelper = null;
        RequestConfig.Builder requestConfigBuilder = null;
        String address = null;
        String key = null;
        String pass = null;
        String user = null;
        String value = null;
        URL url = null;
        try {
            key = prefix + "CONFIG";
            value = props.getProperty(key);
            if (null != value && 0 < value.length()) {
                this.mLogger.debug("Reading configuration from '{}'.", (Object)value);
                p2sHelper = new PathToStream();
                value = p2sHelper.pathToURI(value, false);
                applicationContext = new FileSystemXmlApplicationContext(value);
            } else {
                String packageName = this.getClass().getPackage().getName();
                int packageNameL = packageName.length();
                int bufL = packageNameL + configDefault.length() + 1;
                StringBuffer buf = new StringBuffer(bufL);
                buf.append(packageName);
                for (int i = 0; i < packageNameL; ++i) {
                    if (buf.charAt(i) != '.') continue;
                    buf.setCharAt(i, '/');
                }
                buf.append('/').append(configDefault);
                String contextPath = buf.toString();
                this.mLogger.debug("Reading builtin configuration from '{}'.", (Object)contextPath);
                applicationContext = new ClassPathXmlApplicationContext(contextPath);
            }
            requestConfigBuilder = applicationContext.containsBean("requestConfigBuilder") ? (RequestConfig.Builder)applicationContext.getBean("requestConfigBuilder") : RequestConfig.custom();
            value = props.getProperty("HTTP_REQUEST_TIMEOUT");
            if (null != value && 0 < value.length()) {
                requestConfigBuilder.setSocketTimeout(Integer.parseInt(value));
            }
            RequestConfig requestConfig = requestConfigBuilder.build();
            this.mLogger.debug("RequestConfig connect timeout: {}", (Object)requestConfig.getConnectTimeout());
            this.mLogger.debug("RequestConfig socket timeout:  {}", (Object)requestConfig.getSocketTimeout());
            authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory(Consts.UTF_8)).register("Digest", (Object)new DigestSchemeFactory(Consts.UTF_8)).build();
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).useSystemProperties();
            user = props.getProperty("WSCP_USER");
            pass = props.getProperty("WSCP_PASS");
            if (null != user && 0 < user.length() && null != pass && 0 < pass.length()) {
                credentialsProvider = new BasicCredentialsProvider();
                value = props.getProperty("WSCP_DOMAIN");
                if (null != value && 0 < value.length()) {
                    try {
                        key = prefix + "ADDRESS";
                        address = props.getProperty(key);
                        url = new URL(address);
                        credentials = new NTCredentials(user, pass, url.getHost(), value);
                    }
                    catch (Exception packageName) {
                    }
                    finally {
                        url = null;
                    }
                } else {
                    credentials = new UsernamePasswordCredentials(user, pass);
                }
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            }
            user = props.getProperty("WSCP_PROXY_USER");
            pass = props.getProperty("WSCP_PROXY_PASS");
            if (null != user && 0 < user.length() && null != pass && 0 < pass.length()) {
                if (null == credentialsProvider) {
                    credentialsProvider = new BasicCredentialsProvider();
                }
                AuthScope authScope = new AuthScope(value, port);
                address = value;
                value = props.getProperty("WSCP_PROXY_DOMAIN");
                credentials = null != value && 0 < value.length() ? new NTCredentials(user, pass, address, value) : new UsernamePasswordCredentials(user, pass);
                credentialsProvider.setCredentials(authScope, (Credentials)credentials);
            }
            if (null != credentialsProvider) {
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            if (null != (value = props.getProperty("WSCP_PROXY_HOST")) && 0 < value.length()) {
                port = Integer.parseInt(props.getProperty("WSCP_PROXY_PORT"));
                HttpHost proxyConfig = new HttpHost(value, port, "http");
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyConfig);
                httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            } else {
                httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
            }
            httpClient = httpClientBuilder.build();
        }
        catch (Throwable throwable) {
            if (null != applicationContext && applicationContext instanceof FileSystemXmlApplicationContext) {
                ((FileSystemXmlApplicationContext)applicationContext).close();
            }
            applicationContext = null;
            credentials = null;
            key = null;
            p2sHelper = null;
            pass = null;
            url = null;
            user = null;
            value = null;
            throw throwable;
        }
        if (null != applicationContext && applicationContext instanceof FileSystemXmlApplicationContext) {
            applicationContext.close();
        }
        applicationContext = null;
        credentials = null;
        key = null;
        p2sHelper = null;
        pass = null;
        url = null;
        user = null;
        value = null;
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvokeImplementation getInvokeImpl(WebServiceClientJPC me, Request request, JavaProxyClientCallbacks callbacks) {
        Binding binding;
        QName operQName;
        QName bindingQName;
        WSDLDiscovery wsdlDiscovery;
        String bindingName = me.mProperties.getProperty("WSCP_BINDING");
        String operName = me.mProperties.getProperty("WSCP_OPERATION");
        try {
            wsdlDiscovery = new WSDLDiscovery(me);
            bindingQName = QName.valueOf(bindingName);
            operQName = QName.valueOf(operName);
            binding = wsdlDiscovery.getBinding(bindingQName, operQName);
            if (null == binding) {
                request.respondWithError(105, "Operation '" + operQName.toString() + "' is unknown.");
                InvokeImplementation invokeImplementation = null;
                return invokeImplementation;
            }
            if (0 != binding.getTypeOfBinding().compareTo((Enum)AbsItfBinding.BindingConstants.SOAP11_BINDING4WSDL11) && 0 != binding.getTypeOfBinding().compareTo((Enum)AbsItfBinding.BindingConstants.SOAP12_BINDING4WSDL11) && 0 != binding.getTypeOfBinding().compareTo((Enum)AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20)) {
                request.respondWithError(105, "Binding '" + binding.getTypeOfBinding().toString() + "' is not supported.");
                InvokeImplementation invokeImplementation = null;
                return invokeImplementation;
            }
            InvokeSOAPHTTP invokeImpl = new InvokeSOAPHTTP(wsdlDiscovery, binding, operQName);
            InvokeSOAPHTTP invokeSOAPHTTP = invokeImpl;
            return invokeSOAPHTTP;
        }
        catch (IOException ex) {
            request.respondWithError(104, "Failed to parse WSDL: " + ex.getMessage());
            InvokeImplementation invokeImplementation = null;
            return invokeImplementation;
        }
        finally {
            binding = null;
            bindingName = null;
            bindingQName = null;
            operName = null;
            operQName = null;
            wsdlDiscovery = null;
        }
    }

    @Override
    public String getNamespace(String prefix) {
        for (int i = 0; i < this.mNamespaces.size(); ++i) {
            OMNamespace ns = this.mNamespaces.get(i);
            if (!prefix.equals(ns.getPrefix())) continue;
            return ns.getNamespaceURI();
        }
        return null;
    }

    @Override
    public boolean isStopped() {
        return this.mStop;
    }

    public WebServiceClientJPC(JavaProxyVM javaProxyVM) {
        super(javaProxyVM);
        this.mClassName = "WebServiceClient";
        this.insert("Discover", new Discover());
        this.insert("DiscoverBinding", new DiscoverBinding());
        this.insert("DiscoverInterface", new DiscoverInterface());
        this.insert("DiscoverParameters", new DiscoverParameters());
        this.insert("DiscoverRelease", new DiscoverRelease());
        this.insert("DiscoverService", new DiscoverService());
        this.insert("DiscoverURI", new DiscoverURI());
        this.insert("GetVersion", new GetVersion());
        this.insert("Invoke", new Invoke());
        this.insert("Reset", new Reset());
        this.insert("SetNamespaces", new SetNamespaces());
        this.insert("SetOptions", new SetOptions());
        this.insert("SetParameters", new SetParameters());
        this.insert("Stop", new Stop());
    }

    private class InvokeSOAPHTTP
    implements InvokeImplementation,
    FaultMessageResolver {
        Binding mBinding = null;
        BindingOperation mBindingOper = null;
        QName mOperQName = null;
        boolean mSoapFailed = false;
        QName mSoapFault = null;
        String mSoapReason = null;
        OMElement mRequestTemplate = null;
        WSDLDiscovery mWSDLDiscovery = null;

        InvokeSOAPHTTP(WSDLDiscovery wsdlDiscovery, Binding binding, QName operQName) {
            this.mWSDLDiscovery = wsdlDiscovery;
            this.mBinding = binding;
            this.mOperQName = operQName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            MyHttpComponentsMessageSender messageSender;
            ResponseMessageCallback responseCallback;
            RequestMessageCallback requestCallback;
            AxiomSoapMessageFactory messageFactory;
            WebServiceTemplate webServiceTemplate;
            HttpClient httpClient;
            Wss4jSecurityInterceptor wsSecurityInterceptor;
            String pass;
            String user;
            boolean preemptive = false;
            ClientInterceptor[] interceptors = null;
            int interceptorCt = 0;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                user = me.mProperties.getProperty("WSCP_WS-SECURITY_USER");
                pass = me.mProperties.getProperty("WSCP_WS-SECURITY_PASS");
                boolean digest = Boolean.valueOf(me.mProperties.getProperty("WSCP_WS-SECURITY_DIGEST", "false"));
                WebServiceClientJPC.this.mLogger.debug("WSCP_WS-SECURITY_DIGEST={}", (Object)me.mProperties.getProperty("WSCP_WS-SECURITY_DIGEST", "false"));
                WebServiceClientJPC.this.mLogger.debug("digest={}", (Object)digest);
                if (null != user && 0 < user.length()) {
                    ++interceptorCt;
                }
                String wscpAddress = me.mProperties.getProperty("WSCP_ADDRESS");
                if (0 < interceptorCt) {
                    interceptors = new ClientInterceptor[interceptorCt];
                    interceptorCt = 0;
                    if (null != user && 0 < user.length()) {
                        wsSecurityInterceptor = new Wss4jSecurityInterceptor();
                        wsSecurityInterceptor.setSecureRequest(true);
                        wsSecurityInterceptor.setSecureResponse(false);
                        wsSecurityInterceptor.setSecurementMustUnderstand(Boolean.valueOf(me.mProperties.getProperty("WSCP_WS-SECURITY_MUST")).booleanValue());
                        if (!digest && null != me.mDigestURIs && me.mDigestURIs.contains(wscpAddress)) {
                            digest = true;
                        }
                        if (digest) {
                            WebServiceClientJPC.this.mLogger.debug("Sending password in Digest form");
                            wsSecurityInterceptor.setSecurementPasswordType("PasswordDigest");
                        } else {
                            wsSecurityInterceptor.setSecurementPasswordType("PasswordText");
                        }
                        wsSecurityInterceptor.setSecurementPassword(pass);
                        wsSecurityInterceptor.setSecurementActions("UsernameToken");
                        wsSecurityInterceptor.setSecurementUsername(user);
                        interceptors[interceptorCt++] = wsSecurityInterceptor;
                    }
                }
                httpClient = WebServiceClientJPC.this.getHttpClient(me.mProperties, "WSCP_", "soap-client-config.xml");
                webServiceTemplate = new WebServiceTemplate();
                messageFactory = new AxiomSoapMessageFactory();
                messageFactory.setAttachmentCaching(true);
                messageFactory.setAttachmentCacheDir(new File(System.getProperty("java.io.tmpdir")));
                messageFactory.setAttachmentCacheThreshold(131072);
                String value = me.mProperties.getProperty("SOAP_BINDING");
                SoapVersion soapVersion = value.equals("SOAP_11") ? SoapVersion.SOAP_11 : SoapVersion.SOAP_12;
                messageFactory.setSoapVersion(soapVersion);
                webServiceTemplate.setMessageFactory((WebServiceMessageFactory)messageFactory);
                requestCallback = new RequestMessageCallback(me.mInputParms, this.mRequestTemplate, soapVersion, me.mHeaders);
                value = me.mProperties.getProperty("WSCP_ACTION");
                requestCallback.setAction(value);
                responseCallback = new ResponseMessageCallback(me.mOutputParms, soapVersion);
                webServiceTemplate.setDefaultUri(wscpAddress);
                if (0 < interceptorCt) {
                    webServiceTemplate.setInterceptors(interceptors);
                }
                if (null != (value = me.mProperties.getProperty("WSCP_PREEMPTIVE_AUTHENTICATION")) && 0 < value.length() && Boolean.valueOf(value).booleanValue()) {
                    preemptive = true;
                }
                URI parsedURI = new URI(webServiceTemplate.getDefaultUri());
                messageSender = new MyHttpComponentsMessageSender(httpClient, parsedURI.getHost(), parsedURI.getPort(), preemptive);
                messageSender.setHttpClient(httpClient);
                webServiceTemplate.setMessageSender((WebServiceMessageSender)messageSender);
                webServiceTemplate.setFaultMessageResolver((FaultMessageResolver)this);
                webServiceTemplate.sendAndReceive((WebServiceMessageCallback)requestCallback, (WebServiceMessageCallback)responseCallback);
                if (this.mSoapFailed) {
                    request.respondWithError(2, "FaultCode: " + this.mSoapFault + " (" + this.mSoapReason + ")");
                    boolean bl = false;
                    return bl;
                }
                me.mHttpHeaders = responseCallback.getHeaders();
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable) {
                if (throwable instanceof WebServiceIOException && throwable.getCause() instanceof ConnectException) {
                    callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "Invoke() received a ConnectException.  Verify the URI and proxy information are correct.", throwable.getCause());
                } else {
                    callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "Invoke() received an exception.", throwable);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                httpClient = null;
                interceptors = null;
                me = null;
                messageFactory = null;
                messageSender = null;
                this.mSoapFailed = false;
                this.mSoapFault = null;
                this.mSoapReason = null;
                pass = null;
                requestCallback = null;
                responseCallback = null;
                user = null;
                webServiceTemplate = null;
                wsSecurityInterceptor = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resolveFault(WebServiceMessage message) throws IOException {
            SoapBody soapBody;
            SoapMessage soapMessage;
            try {
                SoapFault soapFault;
                this.mSoapFailed = true;
                soapMessage = (SoapMessage)message;
                soapBody = soapMessage.getSoapBody();
                if (null != soapBody && null != (soapFault = soapBody.getFault())) {
                    this.mSoapFault = soapFault.getFaultCode();
                    this.mSoapReason = soapFault.getFaultStringOrReason();
                }
            }
            finally {
                soapBody = null;
                soapMessage = null;
            }
        }

        @Override
        public void stop(JavaProxyClass jpc) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validate(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            String wsUser;
            QName requestQName;
            QName qName;
            String value;
            Boolean haveError = false;
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            String errors = "";
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                value = me.mProperties.getProperty("WSCP_REQUEST_XML_TEMPLATE");
                if (null != value) {
                    try {
                        this.mRequestTemplate = AXIOMUtil.stringToOM((OMFactory)omFactory, (String)value);
                        qName = SoapVersion.SOAP_11.getEnvelopeName();
                        requestQName = this.mRequestTemplate.getQName();
                        if (qName.equals(requestQName)) {
                            me.mProperties.setProperty("SOAP_BINDING", "SOAP_11");
                        } else {
                            qName = SoapVersion.SOAP_12.getEnvelopeName();
                            if (qName.equals(requestQName)) {
                                me.mProperties.setProperty("SOAP_BINDING", "SOAP_12");
                            } else {
                                if (haveError.booleanValue()) {
                                    errors = errors.concat("; ");
                                }
                                errors = errors.concat("XML Template must have a SOAP Envelope as the root element.");
                                haveError = true;
                            }
                        }
                    }
                    catch (XMLStreamException ex) {
                        if (haveError.booleanValue()) {
                            errors = errors.concat("; ");
                        }
                        errors = errors.concat("Failed to parse request template (" + ex.getMessage() + ").");
                        haveError = true;
                    }
                }
                if (null != this.mOperQName) {
                    this.mBindingOper = (BindingOperation)this.mBinding.getBindingOperation(this.mOperQName.getLocalPart());
                    if (null == this.mBindingOper) {
                        if (haveError.booleanValue()) {
                            errors = errors.concat("; ");
                        }
                        errors = errors.concat("Operation '" + this.mOperQName.toString() + "' was not found.");
                        haveError = true;
                    } else {
                        me.mProperties.setProperty("WSCP_ACTION", this.mBindingOper.getSoapAction());
                    }
                }
                if (null == (value = me.mProperties.getProperty("WSCP_ADDRESS")) || 0 == value.length()) {
                    value = this.mWSDLDiscovery.getAddress(this.mBinding);
                    if (null == value || 0 == value.length()) {
                        if (haveError.booleanValue()) {
                            errors = errors.concat("; ");
                        }
                        errors = errors.concat("Operation '" + this.mOperQName.toString() + "' does not have an associated address.");
                        haveError = true;
                    }
                    me.mProperties.setProperty("WSCP_ADDRESS", value);
                }
                if (null != this.mBinding) {
                    if (0 == this.mBinding.getTypeOfBinding().compareTo((Enum)AbsItfBinding.BindingConstants.SOAP12_BINDING4WSDL11)) {
                        me.mProperties.setProperty("SOAP_BINDING", "SOAP_12");
                    } else {
                        me.mProperties.setProperty("SOAP_BINDING", "SOAP_11");
                    }
                }
                if (null == (value = me.mProperties.getProperty("WSCP_ADDRESS")) || 0 == value.length()) {
                    if (haveError.booleanValue()) {
                        errors = errors.concat("; ");
                    }
                    errors = errors.concat("An address must be specified in the WSDL or via the WSCP_ADDRESS property.");
                    haveError = true;
                } else if (!value.startsWith("http")) {
                    if (haveError.booleanValue()) {
                        errors = errors.concat("; ");
                    }
                    errors = errors.concat("Currently only HTTP is supported (" + value + ")");
                    haveError = true;
                }
                if (null != value && value.startsWith("https")) {
                    wsUser = me.mProperties.getProperty("WSCP_WS-SECURITY_USER");
                    if ((value.startsWith("https") || null != wsUser) && !me.mSecured.booleanValue()) {
                        if (haveError.booleanValue()) {
                            errors = errors.concat("; ");
                        }
                        errors = errors.concat("https and WS-Security require the secure license.");
                        haveError = true;
                    }
                }
                if (haveError.booleanValue()) {
                    request.respondWithError(105, errors);
                    boolean ex = false;
                    return ex;
                }
                boolean ex = true;
                return ex;
            }
            catch (Throwable ex) {
                if (haveError.booleanValue()) {
                    errors = errors.concat("; ");
                }
                errors = errors.concat("Failed to parse request template (" + ex.getMessage() + ").");
                request.respondWithError(105, errors);
                boolean bl = false;
                return bl;
            }
            finally {
                errors = null;
                me = null;
                omFactory = null;
                qName = null;
                requestQName = null;
                value = null;
                wsUser = null;
            }
        }

        public class MyHttpComponentsMessageSender
        extends HttpComponentsMessageSender {
            final HttpHost mHttpHost;
            boolean mPreemptive;

            public MyHttpComponentsMessageSender(HttpClient httpClient, String host, int port, boolean preemptive) {
                super(httpClient);
                WebServiceClientJPC.this.mLogger.debug("MyHttpComponentsMessageSender({}, {}, {}", new Object[]{host, port, Boolean.toString(preemptive)});
                this.mHttpHost = new HttpHost(host, port, "http");
                this.mPreemptive = preemptive;
            }

            protected HttpContext createContext(URI uri) {
                BasicHttpContext httpContext;
                WebServiceClientJPC.this.mLogger.debug("Entered MyHttpComponentsMessageSender.createHttpContext({})", (Object)uri.toString());
                if (this.mPreemptive) {
                    WebServiceClientJPC.this.mLogger.debug("Building authentication cache for preemptive authentication");
                    BasicAuthCache authCache = new BasicAuthCache();
                    BasicScheme basicScheme = new BasicScheme();
                    authCache.put(this.mHttpHost, (AuthScheme)basicScheme);
                    httpContext = new BasicHttpContext();
                    httpContext.setAttribute("http.auth.auth-cache", (Object)authCache);
                } else {
                    httpContext = null;
                }
                return httpContext;
            }
        }
    }

    private class Discover
    extends JavaProxyMethod {
        private final Class<?>[] DISCOVER_SIG = new Class[0];

        public Discover() {
            this.mSig = this.DISCOVER_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            long objectKey = -1L;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                WSDLDiscovery wsdlDiscovery = new WSDLDiscovery(me);
                RowSet properties = wsdlDiscovery.getProperties();
                RowSet content = wsdlDiscovery.getContent();
                objectKey = me.mJavaProxyVM.insertObject((Object)wsdlDiscovery);
                Response response = request.createResponse();
                response.addParameter(objectKey);
                response.addParameter(properties);
                response.addParameter(content);
                request.respond(response);
            }
            catch (IOException ex) {
                request.respondWithError(104, ex.getMessage());
                if (-1L != objectKey) {
                    me.mJavaProxyVM.removeObject(objectKey);
                }
            }
            catch (Throwable throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "Discover() received exception.", throwable);
                if (-1L != objectKey) {
                    me.mJavaProxyVM.removeObject(objectKey);
                }
            }
            finally {
                Object content = null;
                Object properties = null;
                Object response = null;
                Object wsdlDiscovery = null;
            }
        }
    }

    private class DiscoverBinding
    extends JavaProxyMethod {
        private final Class<?>[] DISCOVERBINDING_SIG = new Class[]{Long.class, String.class, String.class};

        public DiscoverBinding() {
            this.mSig = this.DISCOVERBINDING_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            WSDLDiscovery wsdlDiscovery;
            Object object;
            long objectKey = -1L;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                String name;
                object = request.getParameter(0);
                objectKey = (Long)object;
                wsdlDiscovery = (WSDLDiscovery)me.mJavaProxyVM.findObject(objectKey);
                if (null == wsdlDiscovery) {
                    request.respondWithError(105, "The specified WSDL discovery instance does not exist.");
                    return;
                }
                String ns = (String)request.getParameter(1);
                QName qName = new QName(ns, name = (String)request.getParameter(2));
                Binding binding = wsdlDiscovery.getBinding(qName);
                if (null == binding) {
                    request.respondWithError(105, "The specified Binding '" + qName.toString() + "' does not exist.");
                    return;
                }
                RowSet properties = wsdlDiscovery.getProperties(binding);
                RowSet content = wsdlDiscovery.getContent(binding);
                Response response = request.createResponse();
                response.addParameter(properties);
                response.addParameter(content);
                request.respond(response);
            }
            catch (Throwable throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "DiscoverBinding() received exception.", throwable);
            }
            finally {
                Object binding = null;
                Object content = null;
                Object name = null;
                Object ns = null;
                object = null;
                Object properties = null;
                Object qName = null;
                Object response = null;
                wsdlDiscovery = null;
            }
        }
    }

    private class DiscoverInterface
    extends JavaProxyMethod {
        private final Class<?>[] DISCOVERINTERFACE_SIG = new Class[]{Long.class, String.class, String.class};

        public DiscoverInterface() {
            this.mSig = this.DISCOVERINTERFACE_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            WSDLDiscovery wsdlDiscovery;
            Object object;
            long objectKey = -1L;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                String name;
                object = request.getParameter(0);
                objectKey = (Long)object;
                wsdlDiscovery = (WSDLDiscovery)me.mJavaProxyVM.findObject(objectKey);
                if (null == wsdlDiscovery) {
                    request.respondWithError(105, "The specified WSDL discovery instance does not exist.");
                    return;
                }
                String ns = (String)request.getParameter(1);
                QName qName = new QName(ns, name = (String)request.getParameter(2));
                InterfaceType iface = wsdlDiscovery.getInterface(qName);
                if (null == iface) {
                    request.respondWithError(105, "The specified Interface '" + qName.toString() + "' does not exist.");
                    return;
                }
                RowSet properties = wsdlDiscovery.getProperties(iface);
                RowSet content = wsdlDiscovery.getContent(iface);
                Response response = request.createResponse();
                response.addParameter(properties);
                response.addParameter(content);
                request.respond(response);
            }
            catch (Throwable throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "DiscoverInterface() received exception.", throwable);
            }
            finally {
                Object content = null;
                Object iface = null;
                Object name = null;
                Object ns = null;
                object = null;
                Object properties = null;
                Object qName = null;
                Object response = null;
                wsdlDiscovery = null;
            }
        }
    }

    private class DiscoverParameters
    extends JavaProxyMethod {
        private final Class<?>[] DISCOVERPARAMETERS_SIG = new Class[]{Long.class, String.class, String.class, String.class, String.class};

        public DiscoverParameters() {
            this.mSig = this.DISCOVERPARAMETERS_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            WSDLDiscovery wsdlDiscovery;
            Object object;
            long objectKey = -1L;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                String name;
                object = request.getParameter(0);
                objectKey = (Long)object;
                wsdlDiscovery = (WSDLDiscovery)me.mJavaProxyVM.findObject(objectKey);
                if (null == wsdlDiscovery) {
                    request.respondWithError(105, "The specified WSDL discovery instance does not exist.");
                    return;
                }
                String ns = (String)request.getParameter(1);
                QName qName = new QName(ns, name = (String)request.getParameter(2));
                Binding binding = wsdlDiscovery.getBinding(qName);
                if (null == binding) {
                    request.respondWithError(105, "The specified Binding '" + qName.toString() + "' does not exist.");
                    return;
                }
                InterfaceType iface = (InterfaceType)binding.getInterface();
                if (null == iface) {
                    request.respondWithError(105, "The specified Binding '" + qName.toString() + "' does not have an associated Interface.");
                    return;
                }
                ns = (String)request.getParameter(3);
                qName = new QName(ns, name = (String)request.getParameter(4));
                Operation operation = (Operation)iface.getOperation(qName);
                if (null == operation) {
                    request.respondWithError(105, "The specified Operation '" + qName.toString() + "' does not exist.");
                    return;
                }
                RowSet content = wsdlDiscovery.getContent(binding, operation);
                Response response = request.createResponse();
                response.addParameter(content);
                request.respond(response);
            }
            catch (Throwable throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "DiscoverParameters() received exception.", throwable);
            }
            finally {
                Object binding = null;
                Object content = null;
                Object iface = null;
                Object name = null;
                Object ns = null;
                object = null;
                Object operation = null;
                Object qName = null;
                Object response = null;
                wsdlDiscovery = null;
            }
        }
    }

    private class DiscoverRelease
    extends JavaProxyMethod {
        private final Class<?>[] DISCOVERRELEASE_SIG = new Class[]{Long.class};

        public DiscoverRelease() {
            this.mSig = this.DISCOVERRELEASE_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            Object object;
            long objectKey = -1L;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                object = request.getParameter(0);
                objectKey = (Long)object;
                me.mJavaProxyVM.removeObject(objectKey);
                request.respond(new Object[0]);
            }
            catch (Throwable throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "DiscoverRelease() received exception.", throwable);
            }
            finally {
                object = null;
            }
        }
    }

    private class DiscoverService
    extends JavaProxyMethod {
        private final Class<?>[] DISCOVERSERVICE_SIG = new Class[]{Long.class, String.class, String.class};

        public DiscoverService() {
            this.mSig = this.DISCOVERSERVICE_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            WSDLDiscovery wsdlDiscovery;
            Object object;
            long objectKey = -1L;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                String name;
                object = request.getParameter(0);
                objectKey = (Long)object;
                wsdlDiscovery = (WSDLDiscovery)me.mJavaProxyVM.findObject(objectKey);
                if (null == wsdlDiscovery) {
                    request.respondWithError(105, "The specified WSDL discovery instance does not exist.");
                    return;
                }
                String ns = (String)request.getParameter(1);
                QName qName = new QName(ns, name = (String)request.getParameter(2));
                Service service = wsdlDiscovery.getService(qName);
                if (null == service) {
                    request.respondWithError(105, "The specified Service '" + qName.toString() + "' does not exist.");
                    return;
                }
                RowSet properties = wsdlDiscovery.getProperties(service);
                RowSet content = wsdlDiscovery.getContent(service);
                Response response = request.createResponse();
                response.addParameter(properties);
                response.addParameter(content);
                request.respond(response);
            }
            catch (Throwable throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "DiscoverService() received exception.", throwable);
            }
            finally {
                Object content = null;
                Object name = null;
                Object ns = null;
                object = null;
                Object properties = null;
                Object qName = null;
                Object response = null;
                Object service = null;
                wsdlDiscovery = null;
            }
        }
    }

    private class DiscoverURI
    extends JavaProxyMethod {
        private final Class<?>[] DISCOVERURI_SIG = new Class[]{String.class};

        public DiscoverURI() {
            this.mSig = this.DISCOVERURI_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            Response response;
            List variables;
            UriTemplate uriTemplate;
            Class[] columnTypes = new Class[]{String.class};
            RowSet rowSet = null;
            try {
                uriTemplate = new UriTemplate((String)request.getParameter(0));
                variables = uriTemplate.getVariableNames();
                if (null != variables && 0 < variables.size()) {
                    rowSet = WLPBase.newFixedRowSet((int)variables.size(), (Class[])columnTypes);
                    for (int i = 0; i < variables.size(); ++i) {
                        rowSet.setObject(i, 0, variables.get(i));
                    }
                }
                response = request.createResponse();
                response.addParameter(rowSet);
                request.respond(response);
            }
            catch (Throwable throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "DiscoverURI() received exception.", throwable);
            }
            finally {
                response = null;
                rowSet = null;
                uriTemplate = null;
                variables = null;
            }
        }
    }

    private class GetVersion
    extends JavaProxyMethod {
        private final Class<?>[] GETVERSION_SIG = new Class[0];

        public GetVersion() {
            this.mSig = this.GETVERSION_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            RowSet rowSet;
            String proxiesVersion;
            String springWSFramework;
            String springFramework;
            String easyWSDL;
            Class[] columnTypes = new Class[]{String.class, String.class};
            try {
                easyWSDL = "EasyWSDL 2.1";
                springFramework = "Spring Framework " + SpringVersion.getVersion();
                springWSFramework = "Spring Web Services Framework 2.0.0";
                proxiesVersion = BuildInfo.getFullVersion();
                rowSet = WLPBase.newFixedRowSet((int)4, (Class[])columnTypes);
                rowSet.setObject(0, 0, (Object)"Proxies");
                rowSet.setObject(0, 1, (Object)proxiesVersion);
                rowSet.setObject(1, 0, (Object)"EasyWSDL");
                rowSet.setObject(1, 1, (Object)easyWSDL);
                rowSet.setObject(2, 0, (Object)"Spring Framework");
                rowSet.setObject(2, 1, (Object)springFramework);
                rowSet.setObject(3, 0, (Object)"Spring-ws Framework");
                rowSet.setObject(3, 1, (Object)springWSFramework);
                request.respond(new Object[]{rowSet});
            }
            finally {
                easyWSDL = null;
                proxiesVersion = null;
                rowSet = null;
                springFramework = null;
                springWSFramework = null;
            }
        }
    }

    private class Invoke
    extends JavaProxyMethod {
        private final Class<?>[] INVOKE_SIG = new Class[]{RowSet.class};

        public Invoke() {
            this.mSig = this.INVOKE_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            Response response;
            Class[] columnTypes = new Class[]{String.class, String.class, String.class};
            Class[] headerTypes = new Class[]{String.class, String.class};
            RowSet rowSet = null;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                me.mHeaders = (RowSet)request.getParameter(0);
                me.mHttpHeaders = null;
                if (me.mInvokeImpl.execute(jpc, request, callbacks)) {
                    int row;
                    response = request.createResponse();
                    if (null != me.mOutputParms && 0 != me.mOutputParms.size()) {
                        rowSet = WLPBase.newExpandingRowSet((Class[])columnTypes);
                        row = 0;
                        for (WebServiceParameter parm : me.mOutputParms) {
                            if (!(parm.mPipeline instanceof StringOutputPT)) continue;
                            rowSet.setObject(row, 1, (Object)parm.getXPath());
                            rowSet.setObject(row++, 2, (Object)parm.toString());
                        }
                    }
                    response.addParameter(rowSet);
                    rowSet = null;
                    if (null != me.mHttpHeaders && 0 != me.mHttpHeaders.size()) {
                        rowSet = WLPBase.newExpandingRowSet((Class[])headerTypes);
                        row = 0;
                        for (String key : me.mHttpHeaders.keySet()) {
                            for (String value : me.mHttpHeaders.get((Object)key)) {
                                rowSet.setObject(row, 0, (Object)key);
                                rowSet.setObject(row++, 1, (Object)value);
                            }
                        }
                        me.mHttpHeaders = null;
                    }
                    response.addParameter(rowSet);
                    request.respond(response);
                }
            }
            catch (Throwable throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "Invoke() received exception.", throwable);
            }
            finally {
                me = null;
                response = null;
                rowSet = null;
            }
        }
    }

    private class Reset
    extends JavaProxyMethod {
        private final Class<?>[] RESET_SIG = new Class[0];

        public Reset() {
            this.mSig = this.RESET_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            Stop stop;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                stop = new Stop();
                stop.execute(jpc, null, callbacks);
                if (null != me.mInputParms && 0 != me.mInputParms.size()) {
                    for (WebServiceParameter parm : me.mInputParms) {
                        parm.stop();
                    }
                    me.mInputParms = null;
                }
                if (null != me.mOutputParms && 0 != me.mOutputParms.size()) {
                    for (WebServiceParameter parm : me.mOutputParms) {
                        parm.stop();
                    }
                    me.mOutputParms = null;
                }
                if (null == me.mInvokeImpl || me.mInvokeImpl.validate(jpc, request, callbacks)) {
                    request.respond(new Object[0]);
                }
            }
            finally {
                me.mStop = false;
                stop = null;
            }
        }
    }

    private class SetNamespaces
    extends JavaProxyMethod {
        private final Class<?>[] SETNAMESPACES_SIG = new Class[]{RowSet.class};

        public SetNamespaces() {
            this.mSig = this.SETNAMESPACES_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            OMNamespace ns;
            String nsURI;
            String nsPrefix;
            RowSet namespaces;
            OMFactory omFactory;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                omFactory = OMAbstractFactory.getOMFactory();
                namespaces = (RowSet)request.getParameter(0);
                if (null != namespaces) {
                    for (int i = 0; i < namespaces.getRowCount(); ++i) {
                        nsPrefix = (String)namespaces.getObject(i, 0);
                        nsURI = (String)namespaces.getObject(i, 1);
                        ns = omFactory.createOMNamespace(nsURI, nsPrefix);
                        if (null == me.mNamespaces) {
                            me.mNamespaces = new ArrayList();
                        }
                        me.mNamespaces.add(ns);
                    }
                }
                request.respond(new Object[0]);
            }
            catch (Throwable throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "SetNamespaces() received exception.", throwable);
            }
            finally {
                me = null;
                namespaces = null;
                ns = null;
                nsPrefix = null;
                nsURI = null;
                omFactory = null;
            }
        }
    }

    private class SetOptions
    extends JavaProxyMethod {
        private final Class<?>[] SETOPTIONS_SIG = new Class[]{RowSet.class};

        public SetOptions() {
            this.mSig = this.SETOPTIONS_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            String optValue;
            String optName;
            RowSet options;
            PathToStream p2sHelper;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                int foo;
                p2sHelper = new PathToStream();
                if (null == me.mProperties) {
                    me.mProperties = new Properties();
                }
                if (null != (options = (RowSet)request.getParameter(0))) {
                    for (int i = 0; i < options.getRowCount(); ++i) {
                        optName = (String)options.getObject(i, 0);
                        optName = optName.toUpperCase();
                        optValue = (String)options.getObject(i, 1);
                        if (optName.endsWith("_ADDRESS")) {
                            optValue = p2sHelper.pathToURI(optValue, false);
                        }
                        me.mProperties.setProperty(optName, optValue);
                        if (optName.endsWith("PASS")) {
                            optValue = "********";
                        }
                        WebServiceClientJPC.this.mLogger.debug("Set property: {}={}", (Object)optName, (Object)optValue);
                    }
                }
                if (null != (optValue = me.mProperties.getProperty("WSCP_KEY")) && 4 == (4 & (foo = optValue.codePointAt(7)))) {
                    me.mSecured = true;
                }
                if (null != (optValue = me.mProperties.getProperty("WSCP_WSDL_ADDRESS"))) {
                    if (8 < optValue.length() && optValue.substring(0, 7).equalsIgnoreCase("https://") && !me.mSecured.booleanValue()) {
                        request.respondWithError(105, "https requires the secure license.");
                        return;
                    }
                    if (null != me.mProperties.getProperty("WSCP_OPERATION")) {
                        me.mInvokeImpl = WebServiceClientJPC.this.getInvokeImpl(me, request, callbacks);
                        if (null == me.mInvokeImpl) {
                            return;
                        }
                    }
                } else {
                    optValue = me.mProperties.getProperty("WSCP_REQUEST_XML_TEMPLATE");
                    me.mInvokeImpl = null != optValue ? new InvokeSOAPHTTP(null, null, null) : new InvokeHTTP(null, null, null);
                }
                if (null == me.mInvokeImpl || me.mInvokeImpl.validate(jpc, request, callbacks)) {
                    request.respond(new Object[0]);
                }
            }
            catch (IOException throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "SetOptions() received exception.", (Throwable)throwable);
            }
            finally {
                me = null;
                options = null;
                optName = null;
                optValue = null;
                p2sHelper = null;
            }
        }
    }

    private class SetParameters
    extends JavaProxyMethod {
        private final Class<?>[] SETPARAMETERS_SIG = new Class[]{RowSet.class};

        public SetParameters() {
            this.mSig = this.SETPARAMETERS_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            String value;
            int i = 0;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                String[] digestURIs;
                int rows;
                if (WebServiceClientJPC.this.mLogger.isDebugEnabled()) {
                    WebServiceClientJPC.this.mLogger.debug("SetParameters shows keys:");
                    for (Object key : me.mProperties.keySet()) {
                        String keyValue = ((String)key).endsWith("PASS") ? "********" : (String)me.mProperties.get(key);
                        WebServiceClientJPC.this.mLogger.debug("   key: {}={}", key, (Object)keyValue);
                    }
                }
                if (null != (value = me.mProperties.getProperty("WSCP_ADDRESS")) && null != me.mProperties.getProperty("WSCP_WSDL_ADDRESS")) {
                    value = me.mProperties.getProperty("WSCP_OPERATION");
                }
                if (null == value) {
                    if (null == me.mProperties.getProperty("WSCP_ADDRESS")) {
                        request.respondWithError(105, "A Web Service address required.");
                    } else {
                        request.respondWithError(105, "A Web Service address and operation are required.");
                    }
                    return;
                }
                RowSet parameter = (RowSet)request.getParameter(0);
                if (null != parameter && 0 != (rows = parameter.getRowCount())) {
                    while (i < rows) {
                        String errorMessage;
                        String XPath = (String)parameter.getObject(i, 1);
                        String property = (String)parameter.getObject(i, 2);
                        value = (String)parameter.getObject(i, 3);
                        if (null == XPath || 0 == XPath.length()) {
                            request.respondWithError(105, "Expected a parameter XPath.");
                            return;
                        }
                        if (!property.equalsIgnoreCase("direction")) {
                            request.respondWithError(105, "Expected the parameter direction.  Found '" + property + "'.");
                            return;
                        }
                        boolean input = value.equalsIgnoreCase("input");
                        if (++i >= rows) {
                            request.respondWithError(105, "Expected the parameter type property.");
                            return;
                        }
                        WebServiceParameter parm = new WebServiceParameter(Thread.currentThread().getContextClassLoader(), XPath, input);
                        while (i < rows) {
                            Object pipeline;
                            property = (String)parameter.getObject(i, 2);
                            String type = (String)parameter.getObject(i, 3);
                            ++i;
                            if (!property.equalsIgnoreCase("type")) {
                                request.respondWithError(105, "Expected the parameter type property.  Found '" + property + "'.");
                                return;
                            }
                            if (type.equalsIgnoreCase("File")) {
                                pipeline = input ? new FileInputPT(Thread.currentThread().getContextClassLoader()) : new FileOutputPT(Thread.currentThread().getContextClassLoader());
                            } else if (type.equalsIgnoreCase("String")) {
                                pipeline = input ? new StringInputPT(Thread.currentThread().getContextClassLoader()) : new StringOutputPT(Thread.currentThread().getContextClassLoader());
                            } else {
                                request.respondWithError(105, "The parameter type '" + type + "' is unknown.");
                                return;
                            }
                            if (i < rows) {
                                do {
                                    XPath = (String)parameter.getObject(i, 1);
                                    property = (String)parameter.getObject(i, 2);
                                    value = (String)parameter.getObject(i, 3);
                                    Object object = parameter.getObject(i, 4);
                                    if (null != object) {
                                        parm.setIsXML((Boolean)object);
                                    }
                                    if (null != XPath || property.equalsIgnoreCase("type")) break;
                                    ++i;
                                    try {
                                        pipeline.setParameter(property, value);
                                        Throwable throwable = pipeline.getException();
                                        if (null != throwable) {
                                            throw throwable;
                                        }
                                    }
                                    catch (Throwable ex) {
                                        String newMsg = "Failed to capture option '" + property + "', value '" + value + "'. (" + ex.getClass().getName() + ": " + ex.getMessage() + ")";
                                        request.respondWithError(105, newMsg);
                                        me = null;
                                        parameter = null;
                                        parm = null;
                                        pipeline = null;
                                        property = null;
                                        type = null;
                                        value = null;
                                        XPath = null;
                                        return;
                                    }
                                } while (i < rows);
                            }
                            parm.addPipeline((PipelineTransform)pipeline);
                            if (null == XPath) continue;
                        }
                        if (null != (errorMessage = parm.resolve(me))) {
                            request.respondWithError(105, errorMessage);
                            return;
                        }
                        if (input) {
                            if (null == me.mInputParms) {
                                me.mInputParms = new ArrayList();
                            }
                            me.mInputParms.add(parm);
                        } else {
                            if (null == me.mOutputParms) {
                                me.mOutputParms = new ArrayList();
                            }
                            me.mOutputParms.add(parm);
                        }
                        parm = null;
                    }
                }
                if (null != (digestURIs = System.getProperty("WebServiceNodeDigestURIs", "").split(","))) {
                    WebServiceClientJPC.this.mLogger.debug("Found digest URIs");
                    if (null == me.mDigestURIs) {
                        me.mDigestURIs = new ArrayList();
                    }
                    for (String digestURI : digestURIs) {
                        String trimmedURI = digestURI.trim();
                        if (0 >= trimmedURI.length()) continue;
                        WebServiceClientJPC.this.mLogger.debug("Digest URI: '{}'", (Object)trimmedURI);
                        me.mDigestURIs.add(trimmedURI);
                    }
                }
                request.respond(new Object[0]);
            }
            catch (Throwable throwable) {
                callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "SetParameters() received exception.", throwable);
            }
            finally {
                me = null;
                Object parameter = null;
                Object parm = null;
                Object pipeline = null;
                Object property = null;
                Object type = null;
                value = null;
                Object XPath = null;
            }
        }
    }

    private class Stop
    extends JavaProxyMethod {
        private final Class<?>[] STOP_SIG = new Class[0];

        public Stop() {
            this.mSig = this.STOP_SIG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                me.mStop = true;
                if (null != me.mInvokeImpl) {
                    me.mInvokeImpl.stop(jpc);
                }
                if (null != request) {
                    request.respond(new Object[0]);
                }
            }
            finally {
                me.mInputParms = null;
                me.mOutputParms = null;
                if (null != request) {
                    me.mNamespaces = null;
                    me.mProperties = null;
                }
            }
        }
    }

    private class InvokeHTTP
    implements InvokeImplementation,
    ResponseErrorHandler {
        WSDLDiscovery mWSDLDiscovery = null;
        Binding mBinding = null;
        QName mOperQName = null;
        int mStatusCode = 0;
        String mStatusMsg = null;

        InvokeHTTP(WSDLDiscovery wsdlDiscovery, Binding binding, QName operQName) {
            this.mWSDLDiscovery = wsdlDiscovery;
            this.mBinding = binding;
            this.mOperQName = operQName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean execute(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            ResponseEntity responseEntity;
            Scanner scanner;
            HttpEntity httpEntity;
            StreamSource streamSource;
            InputStream inputStream;
            String method;
            HttpHeaders httpHeaders;
            RestTemplate restTemplate;
            MyHttpComponentsClientHttpRequestFactory clientHttpRequestFactory;
            HashMap<String, String> vars;
            String value;
            String uri;
            HttpClient httpClient;
            boolean preemptiveAuth = false;
            Class<String> responseType = null;
            MediaType mediaType = null;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            WebServiceParameter inputParm = null;
            WebServiceParameter outputParm = null;
            try {
                URI parsedURI;
                httpClient = WebServiceClientJPC.this.getHttpClient(me.mProperties, "WSCP_", "http-client-config.xml");
                uri = me.mProperties.getProperty("WSCP_ADDRESS");
                value = me.mProperties.getProperty("WSCP_PREEMPTIVE_AUTHENTICATION");
                if (null != value && 0 < value.length() && Boolean.valueOf(value).booleanValue()) {
                    preemptiveAuth = true;
                }
                vars = new HashMap<String, String>();
                if (null != me.mInputParms && 0 != me.mInputParms.size()) {
                    for (WebServiceParameter parm : me.mInputParms) {
                        if (parm.getXPath().startsWith("http_content_http")) {
                            inputParm = parm;
                            continue;
                        }
                        vars.put(parm.getXPath(), parm.toString());
                    }
                    UriTemplate uriTemplate = new UriTemplate(uri);
                    parsedURI = uriTemplate.expand(vars);
                } else {
                    parsedURI = URI.create(uri);
                }
                clientHttpRequestFactory = new MyHttpComponentsClientHttpRequestFactory(httpClient, parsedURI.getHost(), parsedURI.getPort(), preemptiveAuth);
                restTemplate = new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
                httpHeaders = new HttpHeaders();
                if (null != me.mHeaders) {
                    for (int i = 0; i < me.mHeaders.getRowCount(); ++i) {
                        httpHeaders.add((String)me.mHeaders.getObject(i, 0), (String)me.mHeaders.getObject(i, 1));
                    }
                }
                if (null != (value = me.mProperties.getProperty("WSCP_HTTP_CONTENT_TYPE")) && 0 < value.length()) {
                    mediaType = MediaType.parseMediaType((String)value);
                    httpHeaders.setContentType(mediaType);
                }
                method = null == (method = me.mProperties.getProperty("WSCP_TRANSPORT_HTTP")) ? (null == inputParm ? "GET" : "POST") : method.toUpperCase();
                if (null != me.mOutputParms && 0 < me.mOutputParms.size()) {
                    for (WebServiceParameter parm : me.mOutputParms) {
                        if (!parm.getXPath().equals("http_result_http")) continue;
                        outputParm = parm;
                        responseType = String.class;
                        break;
                    }
                }
                if (null != inputParm) {
                    if (null == mediaType || mediaType.getSubtype().contains("xml")) {
                        inputStream = inputParm.getInputStream();
                        streamSource = new StreamSource(inputStream);
                        httpEntity = new HttpEntity((Object)streamSource, (MultiValueMap)httpHeaders);
                    } else if (mediaType.equals((Object)MediaType.MULTIPART_FORM_DATA)) {
                        LinkedMultiValueMap parts = new LinkedMultiValueMap();
                        String parmName = inputParm.getXPath().startsWith("http_content_http.") ? inputParm.getXPath().substring("http_content_http.".length()) : "input";
                        value = inputParm.toString();
                        if (null == value) {
                            scanner = new Scanner(inputParm.getInputStream(), "UTF-8");
                            value = scanner.useDelimiter("\\A").next();
                            scanner.close();
                        }
                        WebServiceClientJPC.this.mLogger.debug("Adding part '{}':{}", (Object)parmName, (Object)value);
                        parts.add((Object)parmName, (Object)value);
                        httpEntity = new HttpEntity((Object)parts, (MultiValueMap)httpHeaders);
                    } else {
                        value = inputParm.toString();
                        if (null == value) {
                            scanner = new Scanner(inputParm.getInputStream(), "UTF-8");
                            value = scanner.useDelimiter("\\A").next();
                            scanner.close();
                        }
                        httpEntity = new HttpEntity((Object)value, (MultiValueMap)httpHeaders);
                    }
                } else {
                    httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
                }
                restTemplate.setErrorHandler((ResponseErrorHandler)this);
                responseEntity = method.equals("DELETE") ? restTemplate.exchange(uri, HttpMethod.DELETE, httpEntity, responseType, vars) : (method.equals("GET") ? restTemplate.exchange(uri, HttpMethod.GET, httpEntity, responseType, vars) : (method.equals("POST") ? restTemplate.exchange(uri, HttpMethod.POST, httpEntity, responseType, vars) : restTemplate.exchange(uri, HttpMethod.PUT, httpEntity, responseType, vars)));
                if (0 < this.mStatusCode) {
                    request.respondWithError(2, this.mStatusMsg + " (" + this.mStatusCode + ")");
                    boolean parts = false;
                    return parts;
                }
                if (null != responseEntity) {
                    String result;
                    if (responseEntity.hasBody() && null != outputParm && null != (result = (String)responseEntity.getBody())) {
                        outputParm.getOutputStream().write(result.getBytes("utf-8"));
                    }
                    WebServiceClientJPC.this.mHttpHeaders = responseEntity.getHeaders();
                }
                boolean parts = true;
                return parts;
            }
            catch (Throwable throwable) {
                if (throwable instanceof ResourceAccessException && throwable.getCause() instanceof ConnectException) {
                    callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "Invoke() received a ConnectException.  Verify the URI and proxy information are correct.", throwable.getCause());
                } else {
                    callbacks.sendException(request, WebServiceClientJPC.this.mLogger, "Invoke() received an exception.", throwable);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                clientHttpRequestFactory = null;
                httpClient = null;
                httpEntity = null;
                httpHeaders = null;
                inputParm = null;
                inputStream = null;
                me = null;
                mediaType = null;
                method = null;
                this.mStatusCode = 0;
                this.mStatusMsg = null;
                outputParm = null;
                responseEntity = null;
                responseType = null;
                restTemplate = null;
                Object result = null;
                scanner = null;
                streamSource = null;
                uri = null;
                value = null;
                vars = null;
            }
        }

        public void handleError(ClientHttpResponse response) throws IOException {
            HttpStatus httpStatus;
            try {
                httpStatus = response.getStatusCode();
                this.mStatusCode = httpStatus.value();
                this.mStatusMsg = response.getStatusText();
            }
            finally {
                httpStatus = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasError(ClientHttpResponse response) throws IOException {
            HttpStatus httpStatus;
            try {
                httpStatus = response.getStatusCode();
                if (HttpStatus.Series.CLIENT_ERROR == httpStatus.series() || HttpStatus.Series.SERVER_ERROR == httpStatus.series()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                httpStatus = null;
            }
        }

        @Override
        public void stop(JavaProxyClass jpc) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validate(JavaProxyClass jpc, Request request, JavaProxyClientCallbacks callbacks) {
            BindingOperation bo;
            WebServiceClientJPC me = (WebServiceClientJPC)jpc;
            try {
                if (null != this.mWSDLDiscovery) {
                    bo = (BindingOperation)this.mBinding.getBindingOperation(this.mOperQName.getLocalPart());
                    if (null == bo) {
                        request.respondWithError(105, "Operation '" + this.mOperQName.toString() + "' is unknown.");
                        boolean bl = false;
                        return bl;
                    }
                    String value = me.mProperties.getProperty("WSCP_ADDRESS");
                    if (null == value || 0 == value.length()) {
                        value = this.mWSDLDiscovery.getAddress(this.mBinding);
                        if (null == value || 0 == value.length()) {
                            request.respondWithError(105, "Operation '" + this.mOperQName.toString() + "' is not associated with a URI.");
                            boolean bl = false;
                            return bl;
                        }
                        me.mProperties.setProperty("WSCP_ADDRESS", value);
                    }
                    if (null != (value = bo.getHttpMethod()) && 0 < value.length()) {
                        me.mProperties.setProperty("WSCP_TRANSPORT_HTTP", value);
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                bo = null;
                me = null;
                Object value = null;
            }
        }

        public class MyHttpComponentsClientHttpRequestFactory
        extends HttpComponentsClientHttpRequestFactory {
            final HttpHost mHttpHost;
            boolean mPreemptive;

            public MyHttpComponentsClientHttpRequestFactory(HttpClient httpClient, String host, int port, boolean preemptive) {
                super(httpClient);
                this.mHttpHost = new HttpHost(host, port, "http");
                this.mPreemptive = preemptive;
            }

            protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                BasicHttpContext httpContext;
                if (this.mPreemptive) {
                    WebServiceClientJPC.this.mLogger.debug("Building authentication cache for preemptive authentication");
                    BasicAuthCache authCache = new BasicAuthCache();
                    BasicScheme basicScheme = new BasicScheme();
                    authCache.put(this.mHttpHost, (AuthScheme)basicScheme);
                    httpContext = new BasicHttpContext();
                    httpContext.setAttribute("http.auth.auth-cache", (Object)authCache);
                } else {
                    httpContext = null;
                }
                return httpContext;
            }
        }
    }
}

