/*
 * Decompiled with CFR 0.152.
 */
package com.dataflux.proxy.ws;

import com.dataflux.proxy.ws.WebServiceClientJPC;
import com.dataflux.wlp.RowSet;
import com.dataflux.wlp.WLPBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.BasicHttpContext;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.All;
import org.ow2.easywsdl.schema.api.Choice;
import org.ow2.easywsdl.schema.api.ComplexContent;
import org.ow2.easywsdl.schema.api.ComplexType;
import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Extension;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Include;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaWriter;
import org.ow2.easywsdl.schema.api.Sequence;
import org.ow2.easywsdl.schema.api.SimpleContent;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfType;
import org.ow2.easywsdl.schema.impl.ExtensionImpl;
import org.ow2.easywsdl.schema.org.w3._2001.xmlschema.ExtensionType;
import org.ow2.easywsdl.tooling.xsd2xml.XSD2XML;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBindingParam;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfParam;
import org.ow2.easywsdl.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Binding4Wsdl11;
import org.ow2.easywsdl.wsdl.api.binding.wsdl11.soap.soap11.SOAP11Body;
import org.ow2.easywsdl.wsdl.api.binding.wsdl11.soap.soap12.SOAP12Binding4Wsdl11;
import org.ow2.easywsdl.wsdl.api.binding.wsdl11.soap.soap12.SOAP12Body;
import org.ow2.easywsdl.wsdl.api.binding.wsdl20.soap.SOAPBinding4Wsdl20;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class WSDLDiscovery {
    Description mDescription = null;
    Logger mLogger = null;
    HashSet<String> mNameSet = null;
    String mWSDLURI = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypeToSchema(Schema schema, int level, QName qName, Type type) {
        All all = null;
        boolean isTypeQName = true;
        Choice choice = null;
        ComplexType complexType = null;
        List elements = null;
        List schemas = null;
        List types = null;
        QName typeQName = null;
        Schema foundSchema = null;
        Sequence sequence = null;
        Type schemaType = null;
        try {
            typeQName = type.getQName();
            if (null == typeQName) {
                if (null == qName) {
                    return;
                }
                isTypeQName = false;
            } else {
                qName = typeQName;
                typeQName = null;
            }
            if (qName.getNamespaceURI().startsWith("http://www.w3.org/2001/XMLSchema")) {
                return;
            }
            if (isTypeQName) {
                types = schema.getTypes();
                if (null != types && 0 < types.size()) {
                    for (Type t : types) {
                        typeQName = t.getQName();
                        if (null == typeQName || !qName.equals(typeQName)) continue;
                        return;
                    }
                }
                schema.addType((AbsItfType)type);
            }
            if (1 == level && null != (schemas = ((Types)this.mDescription.getTypes()).getSchemas())) {
                for (int i = 0; i < schemas.size(); ++i) {
                    foundSchema = (Schema)schemas.get(i);
                    if (isTypeQName ? null != foundSchema.getType(qName) : null != foundSchema.getElement(qName)) break;
                    foundSchema = null;
                }
                if (null != foundSchema) {
                    schema.setTargetNamespace(foundSchema.getTargetNamespace());
                    schema.setElementFormDefault(foundSchema.getElementFormDefault());
                    schema.setAttributeFormDefault(foundSchema.getAttributeFormDefault());
                }
            }
            if (type instanceof ComplexType) {
                SimpleContent simpleContent;
                Extension extension;
                complexType = (ComplexType)type;
                if (complexType.hasAll()) {
                    all = (All)complexType.getAll();
                    if (null != all) {
                        elements = all.getElements();
                    }
                } else if (complexType.hasChoice()) {
                    choice = (Choice)complexType.getChoice();
                    if (null != choice) {
                        elements = choice.getElements();
                    }
                } else if (complexType.hasComplexContent()) {
                    ComplexContent complexContent = (ComplexContent)complexType.getComplexContent();
                    if (null != complexContent) {
                        extension = (Extension)complexContent.getExtension();
                        if (null != extension) {
                            schemaType = (Type)extension.getBase();
                            if (null != schemaType) {
                                this.addTypeToSchema(schema, level + 1, null, schemaType);
                            }
                            if (null != (sequence = (Sequence)extension.getSequence())) {
                                elements = sequence.getElements();
                            }
                            extension = null;
                        }
                        complexContent = null;
                    }
                } else if (complexType.hasSequence()) {
                    sequence = (Sequence)complexType.getSequence();
                    if (null != sequence) {
                        elements = sequence.getElements();
                    }
                } else if (complexType.hasSimpleContent() && null != (simpleContent = (SimpleContent)complexType.getSimpleContent())) {
                    extension = (Extension)simpleContent.getExtension();
                    if (null != extension) {
                        schemaType = (Type)extension.getBase();
                        if (null != schemaType) {
                            this.addTypeToSchema(schema, level + 1, null, schemaType);
                        }
                        extension = null;
                    }
                    simpleContent = null;
                }
            }
            if (null != elements && 0 < elements.size()) {
                for (Element elem : elements) {
                    type = (Type)elem.getType();
                    if (null == type) continue;
                    this.addTypeToSchema(schema, level + 1, elem.getQName(), type);
                }
            }
        }
        finally {
            all = null;
            choice = null;
            elements = null;
            schemas = null;
            qName = null;
            foundSchema = null;
            sequence = null;
            type = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement cleanseXML(OMElement parent, OMElement elem, boolean redoNS) {
        OMElement child;
        OMNode node;
        Iterator children;
        OMAttribute newAttr;
        OMAttribute attr;
        Iterator attrs;
        Iterator namespaces;
        OMNamespace ns;
        int nsSuffix = 0;
        try {
            String parentPrefix;
            String prefix;
            OMNamespace parentNS;
            ns = elem.getNamespace();
            if (redoNS && null != ns && null != parent) {
                boolean foundPrefix = false;
                parentNS = null;
                Pattern pattern = Pattern.compile("ns[0-9]+");
                prefix = ns.getPrefix();
                this.mLogger.debug("cleanseXML() element: {}, parent: {}", (Object)elem.getQName(), (Object)parent.getQName());
                this.mLogger.debug("cleanseXML() scanning for ns: {}:{}", (Object)prefix, (Object)ns.getNamespaceURI());
                namespaces = parent.getAllDeclaredNamespaces();
                while (namespaces.hasNext()) {
                    Matcher matcher;
                    parentNS = (OMNamespace)namespaces.next();
                    parentPrefix = parentNS.getPrefix();
                    this.mLogger.debug("   declaredNS: {}:{}", (Object)parentPrefix, (Object)parentNS.getNamespaceURI());
                    if (!foundPrefix) {
                        if (null == prefix) {
                            if (null == parentPrefix && !parentNS.getNamespaceURI().equals(ns.getNamespaceURI())) {
                                foundPrefix = true;
                            }
                        } else if (null != parentPrefix && prefix.equals(parentPrefix) && !parentNS.getNamespaceURI().equals(ns.getNamespaceURI())) {
                            foundPrefix = true;
                        } else if (parentNS.getNamespaceURI().equals(ns.getNamespaceURI())) {
                            ns = parentNS;
                            break;
                        }
                    }
                    if (null == parentPrefix || !(matcher = pattern.matcher(parentPrefix)).matches()) continue;
                    try {
                        int suffix = Integer.valueOf(parentPrefix.substring(2));
                        if (suffix <= nsSuffix) continue;
                        nsSuffix = suffix;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (foundPrefix) {
                    ns = OMAbstractFactory.getOMFactory().createOMNamespace(ns.getNamespaceURI(), "ns" + ++nsSuffix);
                }
                if (foundPrefix || ns != parentNS) {
                    ns = foundPrefix ? parent.declareNamespace(ns) : parent.declareNamespace(ns.getNamespaceURI(), ns.getPrefix());
                }
            }
            OMElement newElem = OMAbstractFactory.getOMFactory().createOMElement(elem.getLocalName(), ns);
            String text = elem.getText();
            if (null != text && 0 < (text = text.trim()).length()) {
                this.mLogger.debug("Element '{}' has text '{}'", (Object)elem.getLocalName(), (Object)text);
                if (0 == text.compareTo("?")) {
                    newElem.setText("{" + this.needAName(elem, elem.getLocalName()) + "}");
                } else if (0 == text.compareTo("??")) {
                    newElem.setText("[" + this.needAName(elem, elem.getLocalName()) + "]");
                } else {
                    newElem.setText(text);
                }
            }
            if (null == parent) {
                parent = newElem;
            }
            if (null != (namespaces = elem.getAllDeclaredNamespaces())) {
                while (namespaces.hasNext()) {
                    ns = (OMNamespace)namespaces.next();
                    if (ns.getNamespaceURI().startsWith("http://www.w3.org/2001/XMLSchema")) continue;
                    if (redoNS && null != parent && parent != newElem) {
                        prefix = ns.getPrefix();
                        this.mLogger.debug("cleanseXML() element: {}, parent: {}", (Object)elem.getQName(), (Object)parent.getQName());
                        this.mLogger.debug("cleanseXML() scanning for ns: {}:{}", (Object)prefix, (Object)ns.getNamespaceURI());
                        namespaces = parent.getAllDeclaredNamespaces();
                        while (namespaces.hasNext()) {
                            parentNS = (OMNamespace)namespaces.next();
                            parentPrefix = parentNS.getPrefix();
                            this.mLogger.debug("   declaredNS: {}:{}", (Object)parentPrefix, (Object)parentNS.getNamespaceURI());
                            if (null == prefix) {
                                if (null != parentPrefix || parentNS.getNamespaceURI().equals(ns.getNamespaceURI())) continue;
                                ns = OMAbstractFactory.getOMFactory().createOMNamespace(ns.getNamespaceURI(), "ns" + ++nsSuffix);
                                break;
                            }
                            if (null != parentPrefix && prefix.equals(parentPrefix) && !parentNS.getNamespaceURI().equals(ns.getNamespaceURI())) {
                                ns = OMAbstractFactory.getOMFactory().createOMNamespace(ns.getNamespaceURI(), "ns" + ++nsSuffix);
                                break;
                            }
                            if (!parentNS.getNamespaceURI().equals(ns.getNamespaceURI())) continue;
                            ns = null;
                            break;
                        }
                    }
                    if (null == ns) continue;
                    parent.declareNamespace(ns);
                }
            }
            if (null != (attrs = elem.getAllAttributes())) {
                while (attrs.hasNext()) {
                    attr = (OMAttribute)attrs.next();
                    ns = attr.getNamespace();
                    if (null != ns && (null == (ns = attr.getNamespace()) || ns.getNamespaceURI().startsWith("http://www.w3.org/2001/XMLSchema"))) continue;
                    if (null != ns) {
                        namespaces = parent.getAllDeclaredNamespaces();
                        while (namespaces.hasNext()) {
                            parentNS = (OMNamespace)namespaces.next();
                            if (!parentNS.getNamespaceURI().equals(ns.getNamespaceURI())) continue;
                            ns = parentNS;
                            break;
                        }
                    }
                    newAttr = newElem.addAttribute(attr.getLocalName(), attr.getAttributeValue(), ns);
                    if (0 == attr.getAttributeValue().compareTo("?")) {
                        newAttr.setAttributeValue("{" + this.needAName(elem, attr.getLocalName()) + "}");
                        continue;
                    }
                    if (0 != attr.getAttributeValue().compareTo("??")) continue;
                    newAttr.setAttributeValue("[" + this.needAName(elem, attr.getLocalName()) + "]");
                }
            }
            if (null != (children = elem.getChildren())) {
                while (children.hasNext()) {
                    node = (OMNode)children.next();
                    if (5 == node.getType()) {
                        newElem.getOMFactory().createOMComment((OMContainer)newElem, ((OMComment)node).getValue());
                        continue;
                    }
                    if (1 != node.getType()) continue;
                    child = this.cleanseXML(parent, (OMElement)node, redoNS);
                    text = child.getText();
                    if (null != text) {
                        if (0 == (text = text.trim()).compareTo("?")) {
                            child.setText("{" + this.needAName(elem, child.getLocalName() + "}"));
                        } else if (0 == text.compareTo("??")) {
                            child.setText("[" + this.needAName(elem, child.getLocalName() + "]"));
                        }
                    }
                    newElem.addChild((OMNode)child);
                }
            }
            newElem.build();
            OMElement oMElement = newElem;
            return oMElement;
        }
        finally {
            attr = null;
            attrs = null;
            child = null;
            children = null;
            namespaces = null;
            newAttr = null;
            node = null;
            ns = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAddress(Binding binding) {
        Binding b = null;
        List endpoints = null;
        List services = null;
        try {
            block6: {
                services = this.mDescription.getServices();
                if (null == services) break block6;
                if (0 >= services.size()) break;
                for (Service service : services) {
                    endpoints = service.getEndpoints();
                    if (null == endpoints || 0 >= endpoints.size()) continue;
                    for (Endpoint endpoint : endpoints) {
                        b = (Binding)endpoint.getBinding();
                        if (null == b) continue;
                        if (!b.getQName().equals(binding.getQName())) continue;
                        String string = endpoint.getAddress();
                        return string;
                    }
                }
                break;
            }
        }
        finally {
            b = null;
            endpoints = null;
            services = null;
        }
    }

    public Binding getBinding(QName qName) {
        return (Binding)this.mDescription.getBinding(qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Binding getBinding(QName bindingQName, QName operQName) {
        Binding binding = null;
        BindingOperation bindingOper = null;
        List endpoints = null;
        List services = null;
        QName qName = null;
        try {
            services = this.mDescription.getServices();
            if (null == services || 0 == services.size()) {
                Binding binding2 = null;
                return binding2;
            }
            if (null != bindingQName) {
                for (Service svc : services) {
                    endpoints = svc.getEndpoints();
                    if (null == endpoints || 0 == endpoints.size()) continue;
                    for (Endpoint ept : endpoints) {
                        binding = (Binding)ept.getBinding();
                        if (null == binding) continue;
                        qName = binding.getQName();
                        if (null != qName && qName.equals(bindingQName)) break;
                        binding = null;
                    }
                    if (null == binding) continue;
                    break;
                }
                if (null != binding && null == (bindingOper = (BindingOperation)binding.getBindingOperation(operQName.getLocalPart()))) {
                    binding = null;
                }
            } else {
                for (Service svc : services) {
                    Endpoint ept;
                    endpoints = svc.getEndpoints();
                    if (null == endpoints || 0 == endpoints.size()) continue;
                    Iterator iterator = endpoints.iterator();
                    while (iterator.hasNext() && null == (bindingOper = (BindingOperation)(binding = (Binding)(ept = (Endpoint)iterator.next()).getBinding()).getBindingOperation(operQName.getLocalPart()))) {
                        binding = null;
                    }
                }
            }
            Iterator iterator = binding;
            return iterator;
        }
        finally {
            bindingOper = null;
            endpoints = null;
            services = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet getContent() throws IOException, WSDLException {
        QName qName;
        InterfaceType ifaceType;
        Binding binding;
        InterfaceType serviceIface;
        RowSet rowSet;
        Class[] columnTypes = new Class[]{String.class, String.class, String.class};
        int row = 0;
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        ArrayList<InterfaceType> ifaces = new ArrayList<InterfaceType>();
        try {
            rowSet = WLPBase.newExpandingRowSet((Class[])columnTypes);
            boolean firstRow = true;
            for (Service service : this.mDescription.getServices()) {
                this.mLogger.debug("Querying Service: {}", (Object)service.getQName());
                serviceIface = null;
                boolean useService = false;
                for (Endpoint endpt : service.getEndpoints()) {
                    this.mLogger.debug("   Querying Endpoint: {}", (Object)endpt.getName());
                    binding = (Binding)endpt.getBinding();
                    if (null == binding) continue;
                    this.mLogger.debug("      Endpoint Binding: {}", (Object)binding.getQName());
                    if (!(binding.getTypeOfBinding().equals((Object)AbsItfBinding.BindingConstants.SOAP11_BINDING4WSDL11) || binding.getTypeOfBinding().equals((Object)AbsItfBinding.BindingConstants.SOAP12_BINDING4WSDL11) || binding.getTypeOfBinding().equals((Object)AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20))) {
                        this.mLogger.info("Skipping Binding: {}, Type: {}", (Object)binding.getQName(), (Object)binding.getTypeOfBinding());
                        continue;
                    }
                    if (null != binding.getStyle() && AbsItfBinding.StyleConstant.DOCUMENT != binding.getStyle()) {
                        this.mLogger.info("Skipping Binding: {}, Type: {}, Style: {}", new Object[]{binding.getQName(), binding.getTypeOfBinding(), binding.getStyle()});
                        continue;
                    }
                    if (bindings.contains(binding)) continue;
                    ifaceType = (InterfaceType)binding.getInterface();
                    if (null != ifaceType) {
                        if (binding.getTypeOfBinding().equals((Object)AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20)) {
                            if (null == serviceIface) {
                                serviceIface = ifaceType;
                            } else if (serviceIface != ifaceType) {
                                this.mLogger.info("Skipping Binding: {}, Type: {}, Interface: {}", new Object[]{binding.getQName(), binding.getTypeOfBinding(), ifaceType.getQName()});
                                continue;
                            }
                        }
                        if (!ifaces.contains(ifaceType)) {
                            this.mLogger.debug("      Including Interface: {}", (Object)ifaceType.getQName());
                            ifaces.add(ifaceType);
                        }
                    }
                    this.mLogger.debug("      Including Binding: {}", (Object)binding.getQName());
                    bindings.add(binding);
                    useService = true;
                }
                if (!useService) continue;
                if (firstRow) {
                    rowSet.setObject(row, 0, (Object)"Service");
                    firstRow = false;
                }
                qName = service.getQName();
                rowSet.setObject(row, 1, (Object)"QName.namespace");
                rowSet.setObject(row, 2, (Object)qName.getNamespaceURI());
                rowSet.setObject(++row, 1, (Object)"QName.name");
                rowSet.setObject(row, 2, (Object)qName.getLocalPart());
                ++row;
            }
            firstRow = true;
            for (Binding bind : bindings) {
                qName = bind.getQName();
                if (firstRow) {
                    rowSet.setObject(row, 0, (Object)"Binding");
                    firstRow = false;
                }
                rowSet.setObject(row, 1, (Object)"QName.namespace");
                rowSet.setObject(row, 2, (Object)qName.getNamespaceURI());
                rowSet.setObject(++row, 1, (Object)"QName.name");
                rowSet.setObject(row, 2, (Object)qName.getLocalPart());
                ++row;
            }
            firstRow = true;
            for (InterfaceType iface : ifaces) {
                if (firstRow) {
                    rowSet.setObject(row, 0, (Object)"Interface");
                    firstRow = false;
                }
                qName = iface.getQName();
                rowSet.setObject(row, 1, (Object)"QName.namespace");
                rowSet.setObject(row, 2, (Object)qName.getNamespaceURI());
                rowSet.setObject(++row, 1, (Object)"QName.name");
                rowSet.setObject(row, 2, (Object)qName.getLocalPart());
                ++row;
            }
            RowSet rowSet2 = rowSet;
            return rowSet2;
        }
        finally {
            binding = null;
            bindings = null;
            ifaces = null;
            ifaceType = null;
            qName = null;
            rowSet = null;
            serviceIface = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet getContent(Binding binding) throws IOException, WSDLException {
        List endpoints;
        String value;
        Documentation documentation;
        QName qName;
        Operation operation;
        RowSet rowSet;
        Class[] columnTypes = new Class[]{String.class, String.class, String.class};
        int row = 0;
        try {
            rowSet = WLPBase.newExpandingRowSet((Class[])columnTypes);
            for (BindingOperation BOperation : binding.getBindingOperations()) {
                operation = (Operation)BOperation.getOperation();
                qName = null != operation ? operation.getQName() : BOperation.getQName();
                rowSet.setObject(row, 0, (Object)"Operation");
                rowSet.setObject(row, 1, (Object)qName.getNamespaceURI());
                rowSet.setObject(row, 2, (Object)qName.getLocalPart());
                ++row;
                documentation = BOperation.getDocumentation();
                if (null != documentation && null != (value = documentation.getContent()) && 0 < value.length()) {
                    rowSet.setObject(row, 1, (Object)"Documentation");
                    rowSet.setObject(row, 2, (Object)value);
                    ++row;
                }
                if (null != (value = BOperation.getHttpLocation())) {
                    rowSet.setObject(row, 1, (Object)"WSCP_ADDRESS");
                    rowSet.setObject(row, 2, (Object)value);
                    ++row;
                } else {
                    endpoints = this.mDescription.findEndpointsImplementingInterface((AbsItfInterfaceType)((InterfaceType)binding.getInterface()));
                    if (null != endpoints) {
                        for (Endpoint endpoint : endpoints) {
                            if (!((Binding)endpoint.getBinding()).equals((Object)binding)) continue;
                            value = endpoint.getAddress();
                            if (null == value) break;
                            rowSet.setObject(row, 1, (Object)"WSCP_ADDRESS");
                            rowSet.setObject(row, 2, (Object)value);
                            ++row;
                            break;
                        }
                    }
                }
                if (null == (value = BOperation.getSoapAction())) continue;
                rowSet.setObject(row, 1, (Object)"WSCP_ACTION");
                rowSet.setObject(row, 2, (Object)value);
                ++row;
            }
            if (0 == row) {
                rowSet = null;
            }
            RowSet rowSet2 = rowSet;
            return rowSet2;
        }
        finally {
            documentation = null;
            endpoints = null;
            operation = null;
            qName = null;
            rowSet = null;
            value = null;
        }
    }

    public ElementContent getContent(Element element) throws IOException, XMLStreamException {
        ByteArrayOutputStream byteStream = null;
        ElementContent content = new ElementContent(element.getQName());
        List schemas = null;
        QName qName = null;
        Schema parentSchema = null;
        Schema schema = null;
        SchemaFactory schemaFactory = null;
        SchemaWriter schemaWriter = null;
        String xml = null;
        XSD2XML xsd2xml = null;
        try {
            schemaFactory = SchemaFactory.newInstance();
            schema = schemaFactory.newSchema();
            Type type = (Type)element.getType();
            if (null != type) {
                qName = element.getQName();
                this.addTypeToSchema(schema, 1, qName, type);
                if (null == qName) {
                    qName = type.getQName();
                }
                if (null != qName && null != (schemas = ((Types)this.mDescription.getTypes()).getSchemas())) {
                    for (int i = 0; i < schemas.size(); ++i) {
                        parentSchema = (Schema)schemas.get(i);
                        if (null != element ? null != parentSchema.getElement(qName) : null != parentSchema.getType(qName)) break;
                        parentSchema = null;
                    }
                    if (null != parentSchema) {
                        schema.setAttributeFormDefault(parentSchema.getAttributeFormDefault());
                        schema.setElementFormDefault(parentSchema.getElementFormDefault());
                    }
                }
            }
            this.mLogger.debug("element.getQName()={}", (Object)element.getQName());
            this.mLogger.debug("element.getRef()={}", (Object)element.getRef());
            this.mLogger.debug("element.getTypee()={}", (Object)element.getType());
            schema.addElement((AbsItfElement)element);
            schemaWriter = schemaFactory.newSchemaWriter();
            byteStream = new ByteArrayOutputStream();
            schemaWriter.writeSchema(schema, (OutputStream)byteStream);
            String value = byteStream.toString();
            content.setXMLSchema(value);
            element = (Element)schema.getElement(element.getQName());
            xsd2xml = XSD2XML.newInstance();
            this.mLogger.debug("Schema:\n{}\n", (Object)value);
            Map<Type, Object> defaultValue = XSD2XML.createDefaultMap("?");
            for (Type schemaType : schema.getTypes()) {
                defaultValue.put(schemaType, "?");
            }
            xml = xsd2xml.printXml((AbsItfElement)element, defaultValue, true, true);
            content.setXML(xml);
            this.mLogger.debug("Sample XML:\n{}\n", (Object)xml);
            ElementContent i = content;
            return i;
        }
        catch (SchemaException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            content = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet getContent(InterfaceType iface) throws IOException, WSDLException {
        List operations;
        Class[] columnTypes = new Class[]{String.class, String.class, String.class};
        try {
            operations = iface.getOperations();
            if (null == operations || 0 == operations.size()) {
                RowSet rowSet = null;
                return rowSet;
            }
            RowSet rowSet = WLPBase.newExpandingRowSet((Class[])columnTypes);
            int row = 0;
            for (int i = 0; i < operations.size(); ++i) {
                String value;
                Operation operation = (Operation)operations.get(i);
                rowSet.setObject(row, 0, (Object)"Operation");
                rowSet.setObject(row, 1, (Object)operation.getQName().getNamespaceURI());
                rowSet.setObject(row, 2, (Object)operation.getQName().getLocalPart());
                ++row;
                Documentation documentation = operation.getDocumentation();
                if (null == documentation || null == (value = documentation.getContent()) || 0 == value.length()) continue;
                rowSet.setObject(row, 1, (Object)"Documentation");
                rowSet.setObject(row, 2, (Object)value);
                ++row;
            }
            RowSet rowSet2 = rowSet;
            return rowSet2;
        }
        finally {
            Object operation = null;
            operations = null;
            Object value = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet getContent(Binding binding, Operation operation) throws IOException, WSDLException {
        BindingOperation BOperation;
        RowSet rowSet;
        Class[] columnTypes = new Class[]{String.class, String.class, String.class};
        try {
            rowSet = WLPBase.newExpandingRowSet((Class[])columnTypes);
            BOperation = (BindingOperation)binding.getBindingOperation(operation.getQName().getLocalPart());
            int row = this.getContent("Input", (AbsItfParam)operation.getInput(), (AbsItfBindingParam)BOperation.getInput(), rowSet, 0);
            row = this.getContent("Output", (AbsItfParam)operation.getOutput(), (AbsItfBindingParam)BOperation.getOutput(), rowSet, row);
            for (AbsItfBindingParam fault : BOperation.getFaults()) {
                row = this.getContent("Fault", (AbsItfParam)operation.getFault(fault.getName()), fault, rowSet, row);
            }
            RowSet rowSet2 = rowSet;
            return rowSet2;
        }
        finally {
            BOperation = null;
            rowSet = null;
        }
    }

    public void dumpSchema(Set<String> schemaSet, SchemaWriter schemaWriter, FileOutputStream fileOutput, String indent, Schema schema) {
        if (schemaSet.contains(schema.getTargetNamespace())) {
            this.mLogger.debug(indent + "Already have schema w/target namespace: {} ({})", (Object)schema.getTargetNamespace(), (Object)schema.getDocumentURI());
            return;
        }
        try {
            Schema schm;
            schemaWriter.writeSchema(schema, (OutputStream)fileOutput);
            if (null != schema.getImports()) {
                this.mLogger.debug(indent + "Schema imports");
                for (Import impt : schema.getImports()) {
                    schm = (Schema)impt.getSchema();
                    this.mLogger.debug(indent + "Writing import schema w/target namespace: {} ({})", (Object)schm.getTargetNamespace(), (Object)schm.getDocumentURI());
                    this.dumpSchema(schemaSet, schemaWriter, fileOutput, indent + "   ", schm);
                }
            }
            if (null != schema.getIncludes()) {
                this.mLogger.debug(indent + "Schema includes");
                for (Include incl : schema.getIncludes()) {
                    schm = (Schema)incl.getSchema();
                    this.mLogger.debug(indent + "Writing include schema w/target namespace: {} ({})", (Object)schm.getTargetNamespace(), (Object)schm.getDocumentURI());
                    this.dumpSchema(schemaSet, schemaWriter, fileOutput, indent + "   ", schm);
                }
            }
        }
        catch (SchemaException ex) {
            String message = ex.getMessage();
            this.mLogger.debug(indent + "Received SchemaException: '{}'", (Object)message);
        }
    }

    public int getContent(String paramType, AbsItfParam operParam, AbsItfBindingParam param, RowSet rowSet, int row) throws IOException, WSDLException {
        ElementContent content = null;
        String key = null;
        String value = null;
        try {
            OMNode nodeNext;
            OMNode node;
            SOAPHeaderBlock soapHeaderBlock;
            OMNamespace soapNS;
            Iterator soapNSIterator;
            boolean foundNS;
            OMNamespace headerNS;
            Iterator headerNSIterator;
            OMElement headerBlock;
            Schema schema;
            SOAPHeader soapHeader;
            Element headerElement;
            SOAPEnvelope soapEnvelope;
            SOAPFactory soapFactory;
            SOAPBinding4Wsdl20 soapBinding4Wsdl20;
            Documentation documentation;
            if (null == param || null == operParam) {
                int n = row;
                return n;
            }
            Element element = operParam.getElement();
            if (null == element) {
                this.mLogger.debug(paramType + " Operation: {}", (Object)operParam.getName());
                this.mLogger.debug("   Message Name: {}", (Object)operParam.getMessageName());
                for (Part part : operParam.getParts()) {
                    this.mLogger.debug("   Part: {}", (Object)part.getPartQName());
                    element = part.getElement();
                    if (null != element) {
                        this.mLogger.debug("      element: {}", (Object)element.getQName());
                    }
                    if (null == part.getType()) continue;
                    this.mLogger.debug("      type: {}", (Object)part.getType().getQName());
                }
                element = null;
            }
            if (null != this.mNameSet) {
                this.mNameSet.clear();
            }
            if (null != (documentation = param.getDocumentation()) && 0 == (value = documentation.getContent()).length()) {
                value = null;
            }
            if (null != (soapBinding4Wsdl20 = param.getSOAP12Binding4Wsdl20())) {
                this.mLogger.debug("Have a WSDL 2.0, SOAP 1.2 Binding: {}", (Object)soapBinding4Wsdl20.toString());
                soapFactory = OMAbstractFactory.getSOAP12Factory();
                soapEnvelope = soapFactory.createSOAPEnvelope();
                if (null == element) {
                    throw new IOException("Failed to locate SOAP Body schema element.");
                }
                List soap20Headers = soapBinding4Wsdl20.getHeaders();
                if (null != soap20Headers && 0 < soap20Headers.size()) {
                    headerElement = null;
                    soapHeader = soapFactory.createSOAPHeader(soapEnvelope);
                    for (Object hdr : soap20Headers) {
                        Iterator iterator = ((Types)this.mDescription.getTypes()).getSchemas().iterator();
                        while (iterator.hasNext() && null == (headerElement = (Element)(schema = (Schema)iterator.next()).getElement(hdr.getElement()))) {
                        }
                        if (null == headerElement) {
                            throw new IOException("Failed to locate SOAP Header schema element.");
                        }
                        content = this.getContent(headerElement);
                        headerBlock = content.getXMLAsOMElement();
                        headerNSIterator = headerBlock.getAllDeclaredNamespaces();
                        while (headerNSIterator.hasNext()) {
                            headerNS = (OMNamespace)headerNSIterator.next();
                            foundNS = false;
                            soapNSIterator = soapEnvelope.getAllDeclaredNamespaces();
                            while (soapNSIterator.hasNext()) {
                                soapNS = (OMNamespace)soapNSIterator.next();
                                if (!soapNS.getNamespaceURI().equals(headerNS.getNamespaceURI())) continue;
                                foundNS = true;
                                break;
                            }
                            if (foundNS) continue;
                            soapEnvelope.declareNamespace(headerNS);
                        }
                        soapHeaderBlock = soapFactory.createSOAPHeaderBlock(headerBlock.getLocalName(), headerBlock.getNamespace(), soapHeader);
                        soapHeaderBlock.setMustUnderstand(hdr.isMustUnderstand());
                        node = headerBlock.getFirstOMChild();
                        while (null != node) {
                            nodeNext = node.getNextOMSibling();
                            node.detach();
                            soapHeaderBlock.addChild(node);
                            node = nodeNext;
                        }
                        soapHeader.addChild((OMNode)soapHeaderBlock);
                    }
                }
            } else {
                QName qName;
                SOAP12Binding4Wsdl11 soap12Binding4Wsdl11 = param.getSOAP12Binding4Wsdl11();
                if (null != soap12Binding4Wsdl11) {
                    List soap12Headers;
                    SOAP12Body soap12Body;
                    this.mLogger.debug("Have a WSDL 1.1, SOAP 1.2 Binding: {}", (Object)soap12Binding4Wsdl11.toString());
                    soapFactory = OMAbstractFactory.getSOAP12Factory();
                    soapEnvelope = soapFactory.createSOAPEnvelope();
                    if (null == element && null != (soap12Body = soap12Binding4Wsdl11.getBody())) {
                        if (null != soap12Body.getEncodingStyle()) {
                            this.mLogger.debug("   encoding style: '{}'", (Object)soap12Body.getEncodingStyle());
                        }
                        this.mLogger.debug("   body namespace: '{}'", (Object)soap12Body.getNamespace());
                        if (null != soap12Body.getParts()) {
                            boolean haveParts = false;
                            for (Object str : soap12Body.getParts()) {
                                this.mLogger.debug("   parts: '{}'", str);
                                if (null != element) {
                                    haveParts = true;
                                }
                                if (null != (element = operParam.getPart((String)str).getElement())) continue;
                                throw new IOException("Failed to locate SOAP Body schema element.");
                            }
                            if (haveParts) {
                                throw new IOException("SOAP Message has multiple top level parts.");
                            }
                        }
                    }
                    if (null != (soap12Headers = soap12Binding4Wsdl11.getHeaders()) && 0 < soap12Headers.size()) {
                        headerElement = null;
                        soapHeader = soapFactory.createSOAPHeader(soapEnvelope);
                        for (Object hdr : soap12Headers) {
                            Object str;
                            str = ((Types)this.mDescription.getTypes()).getSchemas().iterator();
                            while (str.hasNext() && null == (headerElement = (Element)(schema = (Schema)str.next()).getElement(qName = new QName(schema.getTargetNamespace(), hdr.getPart())))) {
                            }
                            if (null == headerElement) {
                                throw new IOException("Failed to locate SOAP Header schema element.");
                            }
                            content = this.getContent(headerElement);
                            headerBlock = content.getXMLAsOMElement();
                            headerNSIterator = headerBlock.getAllDeclaredNamespaces();
                            while (headerNSIterator.hasNext()) {
                                headerNS = (OMNamespace)headerNSIterator.next();
                                foundNS = false;
                                soapNSIterator = soapEnvelope.getAllDeclaredNamespaces();
                                while (soapNSIterator.hasNext()) {
                                    soapNS = (OMNamespace)soapNSIterator.next();
                                    if (!soapNS.getNamespaceURI().equals(headerNS.getNamespaceURI())) continue;
                                    foundNS = true;
                                    break;
                                }
                                if (foundNS) continue;
                                soapEnvelope.declareNamespace(headerNS);
                            }
                            soapHeaderBlock = soapFactory.createSOAPHeaderBlock(headerBlock.getLocalName(), headerBlock.getNamespace(), soapHeader);
                            node = headerBlock.getFirstOMChild();
                            while (null != node) {
                                nodeNext = node.getNextOMSibling();
                                node.detach();
                                soapHeaderBlock.addChild(node);
                                node = nodeNext;
                            }
                            soapHeader.addChild((OMNode)soapHeaderBlock);
                        }
                    }
                } else {
                    SOAP11Binding4Wsdl11 soap11Binding4Wsdl11 = param.getSOAP11Binding4Wsdl11();
                    if (null != soap11Binding4Wsdl11) {
                        List soap11Headers;
                        SOAP11Body soap11Body;
                        this.mLogger.debug("Have a WSDL 1.1, SOAP 1.1 Binding: {}", (Object)soap11Binding4Wsdl11.toString());
                        soapFactory = OMAbstractFactory.getSOAP11Factory();
                        soapEnvelope = soapFactory.createSOAPEnvelope();
                        if (null == element && null != (soap11Body = soap11Binding4Wsdl11.getBody())) {
                            if (null != soap11Body.getEncodingStyles()) {
                                for (Object str : soap11Body.getEncodingStyles()) {
                                    this.mLogger.debug("   encoding style: '{}'", str);
                                }
                            }
                            this.mLogger.debug("   body namespace: '{}'", (Object)soap11Body.getNamespace());
                            if (null != soap11Body.getParts()) {
                                boolean haveParts = false;
                                for (Object str : soap11Body.getParts()) {
                                    this.mLogger.debug("   parts: '{}'", str);
                                    if (null != element) {
                                        haveParts = true;
                                    }
                                    if (null != (element = operParam.getPart((String)str).getElement())) continue;
                                    throw new IOException("Failed to locate SOAP Body schema element.");
                                }
                                if (haveParts) {
                                    throw new IOException("SOAP Message has multiple top level parts.");
                                }
                            }
                        }
                        if (null != (soap11Headers = soap11Binding4Wsdl11.getHeaders()) && 0 < soap11Headers.size()) {
                            soapHeader = soapFactory.createSOAPHeader(soapEnvelope);
                            for (Object hdr : soap11Headers) {
                                this.mLogger.debug("Processing SOAP Header: {}", (Object)hdr.getPart());
                                this.mLogger.debug("  Message: {}", (Object)hdr.getMessage());
                                this.mLogger.debug("  Namespace: {}", (Object)hdr.getNamespace());
                                Part part = operParam.getPart(hdr.getPart());
                                headerElement = null;
                                if (null != part) {
                                    headerElement = part.getElement();
                                }
                                if (null == headerElement) {
                                    for (Schema schema2 : ((Types)this.mDescription.getTypes()).getSchemas()) {
                                        qName = new QName(schema2.getTargetNamespace(), hdr.getPart());
                                        this.mLogger.debug("   Looking for Part QName: {}", (Object)qName);
                                        headerElement = (Element)schema2.getElement(qName);
                                        if (null != headerElement) break;
                                        qName = new QName(hdr.getNamespace(), hdr.getPart());
                                        this.mLogger.debug("   Looking for Part QName: {}", (Object)qName);
                                        headerElement = (Element)schema2.getElement(qName);
                                        if (null == headerElement) continue;
                                        break;
                                    }
                                }
                                if (null == headerElement) {
                                    throw new IOException("Failed to locate SOAP Header schema element.");
                                }
                                content = this.getContent(headerElement);
                                headerBlock = content.getXMLAsOMElement();
                                headerNSIterator = headerBlock.getAllDeclaredNamespaces();
                                while (headerNSIterator.hasNext()) {
                                    headerNS = (OMNamespace)headerNSIterator.next();
                                    foundNS = false;
                                    soapNSIterator = soapEnvelope.getAllDeclaredNamespaces();
                                    while (soapNSIterator.hasNext()) {
                                        soapNS = (OMNamespace)soapNSIterator.next();
                                        if (!soapNS.getNamespaceURI().equals(headerNS.getNamespaceURI())) continue;
                                        foundNS = true;
                                        break;
                                    }
                                    if (foundNS) continue;
                                    soapEnvelope.declareNamespace(headerNS);
                                }
                                soapHeaderBlock = soapFactory.createSOAPHeaderBlock(headerBlock.getLocalName(), headerBlock.getNamespace(), soapHeader);
                                node = headerBlock.getFirstOMChild();
                                while (null != node) {
                                    nodeNext = node.getNextOMSibling();
                                    node.detach();
                                    soapHeaderBlock.addChild(node);
                                    node = nodeNext;
                                }
                                soapHeader.addChild((OMNode)soapHeaderBlock);
                            }
                        }
                    } else {
                        throw new IOException("Unsupported binding.");
                    }
                }
            }
            SOAPBody soapBody = soapFactory.createSOAPBody(soapEnvelope);
            if (null != element) {
                content = this.getContent(element);
                OMElement contentElement = content.getXMLAsOMElement();
                String text = contentElement.getText().trim();
                if (!text.isEmpty()) {
                    if (text.startsWith("{")) {
                        soapBody.getOMFactory().createOMComment((OMContainer)soapBody, " Required ");
                    } else {
                        soapBody.getOMFactory().createOMComment((OMContainer)soapBody, " Optional ");
                    }
                }
                soapBody.addChild((OMNode)contentElement);
            }
            soapEnvelope.build();
            String xml = this.cleanseXML(null, (OMElement)soapEnvelope, true).toStringWithConsume();
            soapEnvelope.close(false);
            rowSet.setObject(row, 0, (Object)paramType);
            if (null != element) {
                rowSet.setObject(row, 1, (Object)element.getQName().getNamespaceURI());
                rowSet.setObject(row, 2, (Object)element.getQName().getLocalPart());
            }
            ++row;
            if (null != value) {
                rowSet.setObject(row, 1, (Object)"Documentation");
                rowSet.setObject(row, 2, (Object)value);
                ++row;
            }
            if (null != content && null != (value = content.getXMLSchema())) {
                rowSet.setObject(row, 1, (Object)"Schema");
                rowSet.setObject(row, 2, (Object)value);
                ++row;
            }
            try {
                Enumeration<?> propKeys;
                StringReader stringReader = new StringReader(xml);
                StreamSource source = new StreamSource(stringReader);
                StringWriter stringWriter = new StringWriter();
                StreamResult result = new StreamResult(stringWriter);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                Properties props = transformer.getOutputProperties();
                if (null != props && null != (propKeys = props.propertyNames())) {
                    while (propKeys.hasMoreElements()) {
                        key = (String)propKeys.nextElement();
                        if (!key.endsWith("}indent-amount")) continue;
                        transformer.setOutputProperty(key, "3");
                        break;
                    }
                }
                transformer.transform(source, result);
                value = System.getProperty("line.separator").equals("\n") ? stringWriter.toString() : stringWriter.toString().replaceAll(System.getProperty("line.separator"), "\n");
                stringWriter.close();
            }
            catch (TransformerConfigurationException text) {
            }
            catch (TransformerException text) {
                // empty catch block
            }
            rowSet.setObject(row, 1, (Object)"XML");
            rowSet.setObject(row, 2, (Object)value);
            this.mLogger.debug("Complete envelope: {}", (Object)value);
            int text = ++row;
            return text;
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            content = null;
            Object documentation = null;
            Object element = null;
            Object headerBlock = null;
            Object headerElement = null;
            Object headerNS = null;
            Object headerNSIterator = null;
            key = null;
            Object node = null;
            Object nodeNext = null;
            Object qName = null;
            Object propKeys = null;
            Object props = null;
            Object result = null;
            Object soap11Binding4Wsdl11 = null;
            Object soap11Headers = null;
            Object soapBody = null;
            Object soapEnvelope = null;
            Object soapFactory = null;
            Object soapHeader = null;
            Object soapHeaderBlock = null;
            Object soapNS = null;
            Object soapNSIterator = null;
            Object source = null;
            Object stringReader = null;
            Object stringWriter = null;
            Object transformer = null;
            value = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet getContent(Service service) throws IOException, WSDLException {
        QName qName;
        String value;
        Documentation documentation;
        Binding binding;
        RowSet rowSet;
        Class[] columnTypes = new Class[]{String.class, String.class, String.class};
        int row = 0;
        try {
            rowSet = WLPBase.newExpandingRowSet((Class[])columnTypes);
            for (Endpoint endpoint : service.getEndpoints()) {
                binding = (Binding)endpoint.getBinding();
                if (null != binding && !binding.getTypeOfBinding().equals((Object)AbsItfBinding.BindingConstants.SOAP11_BINDING4WSDL11) && !binding.getTypeOfBinding().equals((Object)AbsItfBinding.BindingConstants.SOAP12_BINDING4WSDL11) && !binding.getTypeOfBinding().equals((Object)AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20)) continue;
                this.mLogger.debug("Returning Endpoint: {}", (Object)endpoint.getName());
                rowSet.setObject(row, 0, (Object)"Endpoint");
                rowSet.setObject(row, 1, (Object)endpoint.getName());
                ++row;
                documentation = endpoint.getDocumentation();
                if (null != documentation && null != (value = documentation.getContent()) && 0 != value.length()) {
                    rowSet.setObject(row, 1, (Object)"Documentation");
                    rowSet.setObject(row, 2, (Object)value);
                    ++row;
                }
                if (null == binding || null == (qName = binding.getQName())) continue;
                this.mLogger.debug("Returning Endpoint Binding: {}", (Object)qName.toString());
                rowSet.setObject(row, 1, (Object)"Binding.Name");
                rowSet.setObject(row, 2, (Object)qName.getLocalPart());
                rowSet.setObject(++row, 1, (Object)"Binding.Namespace");
                rowSet.setObject(row, 2, (Object)qName.getNamespaceURI());
                ++row;
            }
            if (0 == row) {
                rowSet = null;
            }
            RowSet rowSet2 = rowSet;
            return rowSet2;
        }
        finally {
            binding = null;
            documentation = null;
            qName = null;
            rowSet = null;
            value = null;
        }
    }

    public InterfaceType getInterface(QName qName) {
        return (InterfaceType)this.mDescription.getInterface(qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet getProperties() throws IOException, WSDLException {
        RowSet rowSet;
        QName qName;
        String docString;
        Documentation documentation;
        Class[] columnTypes = new Class[]{String.class, String.class};
        int row = 2;
        try {
            documentation = this.mDescription.getDocumentation();
            if (null != documentation) {
                docString = documentation.getContent();
                if (null != docString && 0 != docString.length()) {
                    ++row;
                } else {
                    docString = null;
                }
            } else {
                docString = null;
            }
            qName = this.mDescription.getQName();
            if (null != qName) {
                row += 2;
            }
            rowSet = WLPBase.newFixedRowSet((int)row, (Class[])columnTypes);
            row = 0;
            if (null != qName) {
                rowSet.setObject(row, 0, (Object)"QName.namespace");
                rowSet.setObject(row, 1, (Object)qName.getNamespaceURI());
                rowSet.setObject(++row, 0, (Object)"QName.name");
                rowSet.setObject(row, 1, (Object)qName.getLocalPart());
                ++row;
            }
            rowSet.setObject(row, 0, (Object)"TargetNamespace");
            rowSet.setObject(row, 1, (Object)this.mDescription.getTargetNamespace());
            rowSet.setObject(++row, 0, (Object)"Version");
            rowSet.setObject(row, 1, (Object)this.mDescription.getVersion().toString());
            ++row;
            if (null != docString) {
                rowSet.setObject(row, 0, (Object)"Documentation");
                rowSet.setObject(row, 1, (Object)docString);
                ++row;
            }
            RowSet rowSet2 = rowSet;
            return rowSet2;
        }
        finally {
            docString = null;
            documentation = null;
            qName = null;
            rowSet = null;
        }
    }

    public RowSet getProperties(Binding binding) throws IOException, WSDLException {
        InterfaceType iface;
        Class[] columnTypes = new Class[]{String.class, String.class};
        int row = 1;
        QName qName = null;
        String docString = null;
        String style = null;
        Documentation documentation = binding.getDocumentation();
        if (null != documentation) {
            docString = documentation.getContent();
            if (null != docString && 0 != docString.length()) {
                ++row;
            } else {
                docString = null;
            }
        }
        if (null != (iface = (InterfaceType)binding.getInterface())) {
            qName = iface.getQName();
            if (null != qName) {
                row += 2;
            }
            iface = null;
        }
        if (AbsItfBinding.StyleConstant.DOCUMENT == binding.getStyle()) {
            style = "document";
            ++row;
        } else if (AbsItfBinding.StyleConstant.RPC == binding.getStyle()) {
            style = "rpc";
            ++row;
        }
        RowSet rowSet = WLPBase.newFixedRowSet((int)row, (Class[])columnTypes);
        row = 0;
        if (null != docString) {
            rowSet.setObject(row, 0, (Object)"Documentation");
            rowSet.setObject(row, 1, (Object)docString);
            ++row;
            docString = null;
        }
        if (null != qName) {
            rowSet.setObject(row, 0, (Object)"Interface.Name");
            rowSet.setObject(row, 1, (Object)qName.getLocalPart());
            rowSet.setObject(++row, 0, (Object)"Interface.Namespace");
            rowSet.setObject(row, 1, (Object)qName.getNamespaceURI());
            ++row;
            qName = null;
        }
        if (null != style) {
            rowSet.setObject(row, 0, (Object)"Style");
            rowSet.setObject(row, 1, (Object)style);
            ++row;
        }
        return rowSet;
    }

    public RowSet getProperties(InterfaceType iface) throws IOException, WSDLException {
        Class[] columnTypes = new Class[]{String.class, String.class};
        int row = 0;
        RowSet rowSet = null;
        String docString = null;
        Documentation documentation = iface.getDocumentation();
        if (null != documentation) {
            docString = documentation.getContent();
            if (null != docString && 0 != docString.length()) {
                ++row;
            } else {
                docString = null;
            }
        }
        if (0 != row) {
            rowSet = WLPBase.newFixedRowSet((int)row, (Class[])columnTypes);
            row = 0;
            if (null != docString) {
                rowSet.setObject(row, 0, (Object)"Documentation");
                rowSet.setObject(row, 1, (Object)docString);
                ++row;
                docString = null;
            }
        }
        return rowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet getProperties(Service service) throws IOException, WSDLException {
        InterfaceType iface;
        Documentation documentation;
        Class[] columnTypes = new Class[]{String.class, String.class};
        int row = 0;
        InterfaceType ifaceFirst = null;
        QName qName = null;
        RowSet rowSet = null;
        String docString = null;
        try {
            documentation = service.getDocumentation();
            if (null != documentation) {
                docString = documentation.getContent();
                if (null != docString && 0 != docString.length()) {
                    ++row;
                } else {
                    docString = null;
                }
            }
            for (Endpoint ep : service.getEndpoints()) {
                Binding binding = (Binding)ep.getBinding();
                if (null == binding || !binding.getTypeOfBinding().equals((Object)AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20) || null == (iface = (InterfaceType)binding.getInterface())) continue;
                if (null == ifaceFirst) {
                    ifaceFirst = iface;
                    continue;
                }
                if (ifaceFirst == iface) continue;
                throw new WSDLException("WSDL 1.1: The endpoints of this service do not implement the same interface");
            }
            if (null != ifaceFirst && null != (qName = ifaceFirst.getQName())) {
                row += 2;
            }
            if (0 != row) {
                rowSet = WLPBase.newFixedRowSet((int)row, (Class[])columnTypes);
                row = 0;
                if (null != docString) {
                    rowSet.setObject(row, 0, (Object)"Documentation");
                    rowSet.setObject(row, 1, (Object)docString);
                    ++row;
                    docString = null;
                }
                if (null != qName) {
                    rowSet.setObject(row, 0, (Object)"Interface.Name");
                    rowSet.setObject(row, 1, (Object)qName.getLocalPart());
                    rowSet.setObject(++row, 0, (Object)"Interface.Namespace");
                    rowSet.setObject(row, 1, (Object)qName.getNamespaceURI());
                    ++row;
                    qName = null;
                }
            }
            Iterator iterator = rowSet;
            return iterator;
        }
        finally {
            docString = null;
            documentation = null;
            iface = null;
            ifaceFirst = null;
            qName = null;
            rowSet = null;
        }
    }

    public Service getService(QName qName) {
        return (Service)this.mDescription.getService(qName);
    }

    private String needAName(OMElement elem, String name) {
        int i = 1;
        if (null == this.mNameSet) {
            this.mNameSet = new HashSet();
        }
        if (this.mNameSet.add(name)) {
            return name;
        }
        if (elem.getParent() instanceof OMElement) {
            elem = (OMElement)elem.getParent();
            return this.needAName(elem, elem.getLocalName() + "_" + name);
        }
        while (!this.mNameSet.add(name + ++i)) {
        }
        return name + i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patch() {
        Type schemaType;
        QName qName;
        Extension extension;
        ComplexType complexType;
        Types types;
        try {
            types = (Types)this.mDescription.getTypes();
            if (null != types) {
                for (Schema schema : types.getSchemas()) {
                    for (Type type : schema.getTypes()) {
                        SimpleContent simpleContent;
                        if (!(type instanceof ComplexType)) continue;
                        complexType = (ComplexType)type;
                        extension = null;
                        if (complexType.hasComplexContent()) {
                            ComplexContent complexContent = (ComplexContent)complexType.getComplexContent();
                            if (null != complexContent) {
                                extension = (Extension)complexContent.getExtension();
                            }
                        } else if (complexType.hasSimpleContent() && null != (simpleContent = (SimpleContent)complexType.getSimpleContent())) {
                            extension = (Extension)simpleContent.getExtension();
                        }
                        if (null == extension || null != extension.getBase() || !(extension instanceof ExtensionImpl)) continue;
                        ExtensionImpl extImpl = (ExtensionImpl)extension;
                        if (extImpl.getModel() instanceof ExtensionType) {
                            ExtensionType extType = (ExtensionType)extImpl.getModel();
                            qName = null;
                            if (null != null) {
                                for (Schema nestedSchema : ((Types)this.mDescription.getTypes()).getSchemas()) {
                                    schemaType = (Type)nestedSchema.getType(qName);
                                    if (null == schemaType) continue;
                                    extension.setBase((AbsItfType)schemaType);
                                    break;
                                }
                            }
                            extType = null;
                        }
                        extImpl = null;
                    }
                }
            }
        }
        finally {
            complexType = null;
            extension = null;
            qName = null;
            schemaType = null;
            types = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSDLDiscovery(WebServiceClientJPC me) throws IOException {
        BasicHttpContext httpContext = null;
        ByteArrayInputStream byteStream = null;
        try {
            InputSource inputSource;
            this.mLogger = LoggerFactory.getLogger((String)(me.getLogger().getName() + ".Discovery"));
            String wsdl = me.mProperties.getProperty("WSCP_WSDL");
            String wsdlAddress = me.mProperties.getProperty("WSCP_WSDL_ADDRESS");
            if (null == wsdlAddress && null == wsdl) {
                throw new IOException("Either a WSDL address or content must be specified for discovery.");
            }
            if (null != wsdlAddress && null != wsdl) {
                throw new IOException("Only one of a WSDL content or address may be specified.");
            }
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
            if (this.mLogger.isDebugEnabled()) {
                wsdlReader.setFeature(WSDLReader.FeatureConstants.VERBOSE, (Object)true);
            }
            if (this.mLogger.isTraceEnabled()) {
                wsdlReader.setFeature(WSDLReader.FeatureConstants.IMPORT_DOCUMENTS, (Object)true);
            }
            if (null != wsdlAddress) {
                URL wsdlURL = new URL(wsdlAddress);
                if (wsdlURL.getProtocol().equals("http") || wsdlURL.getProtocol().equals("https")) {
                    HttpClient httpClient = me.getHttpClient(me.mProperties, "WSCP_WSDL_", "soap-client-config.xml");
                    HttpGet httpGet = new HttpGet(me.mProperties.getProperty("WSCP_WSDL_ADDRESS"));
                    String value = me.mProperties.getProperty("WSCP_PREEMPTIVE_AUTHENTICATION");
                    if (null != value && 0 < value.length() && Boolean.valueOf(value).booleanValue()) {
                        BasicAuthCache authCache = new BasicAuthCache();
                        BasicScheme basicScheme = new BasicScheme();
                        authCache.put(new HttpHost(httpGet.getURI().getHost(), httpGet.getURI().getPort(), "http"), (AuthScheme)basicScheme);
                        httpContext = new BasicHttpContext();
                        httpContext.setAttribute("http.auth.auth-cache", (Object)authCache);
                    }
                    HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet, httpContext);
                    HttpEntity httpEntity = httpResponse.getEntity();
                    StatusLine statusLine = httpResponse.getStatusLine();
                    this.mLogger.debug("httpClient.execute(): statusCode={}, text='{}'", (Object)statusLine.getStatusCode(), (Object)statusLine.getReasonPhrase());
                    if (200 != statusLine.getStatusCode()) {
                        throw new IOException(statusLine.getStatusCode() + " - " + statusLine.getReasonPhrase());
                    }
                    inputSource = new InputSource(httpEntity.getContent());
                    this.mDescription = wsdlReader.read(inputSource);
                } else {
                    this.mDescription = wsdlReader.read(wsdlURL);
                }
            } else {
                byteStream = new ByteArrayInputStream(wsdl.getBytes("UTF-8"));
                inputSource = new InputSource(byteStream);
                this.mDescription = wsdlReader.read(inputSource);
            }
            if (AbsItfDescription.WSDLVersionConstants.WSDL20 == this.mDescription.getVersion()) {
                throw new IOException("WSDL 2.0 is not supported.");
            }
            this.patch();
            if (this.mLogger.isDebugEnabled()) {
                List schemas;
                Types types;
                String doc;
                this.mLogger.debug("WSDL Version: {}", (Object)this.mDescription.getVersion().name());
                Documentation documentation = this.mDescription.getDocumentation();
                if (null != documentation && null != (doc = documentation.getContent()) && 0 != doc.length()) {
                    this.mLogger.debug("   Documentation: {}", (Object)doc);
                }
                if (null != (types = (Types)this.mDescription.getTypes()) && null != (schemas = types.getSchemas()) && 0 < schemas.size()) {
                    this.mLogger.debug("Schemas:");
                    for (Schema schema : schemas) {
                        List imports;
                        URI locURI = schema.getDocumentURI();
                        if (null != locURI) {
                            this.mLogger.debug("   Document URI: {}", (Object)locURI);
                        }
                        if (null != schema.getTargetNamespace()) {
                            this.mLogger.debug("   Target Namespace: {}", (Object)schema.getTargetNamespace());
                        }
                        if (null == (imports = schema.getImports()) || 0 >= imports.size()) continue;
                        this.mLogger.debug("   Imports:");
                        for (Import imp : imports) {
                            Map attrs;
                            this.mLogger.debug("      Namespace URI: {}", (Object)imp.getNamespaceURI());
                            documentation = imp.getDocumentation();
                            if (null != documentation && null != (doc = documentation.getContent()) && 0 != doc.length()) {
                                this.mLogger.debug("      Documentation: {}", (Object)doc);
                            }
                            if (null != (locURI = imp.getLocationURI())) {
                                this.mLogger.debug("      Location URI: {}", (Object)locURI);
                            }
                            if (null == (attrs = imp.getOtherAttributes()) || 0 >= attrs.size()) continue;
                            this.mLogger.debug("      Attributes:");
                            for (Map.Entry attr : attrs.entrySet()) {
                                this.mLogger.debug("         Key: {}, Value: {}", attr.getKey(), attr.getValue());
                            }
                        }
                    }
                }
            }
        }
        catch (ConnectException ex) {
            String msg = "Failed to contact the server for the requested WSDL (" + ex.getMessage() + ").";
            throw new IOException(msg);
        }
        catch (URISyntaxException ex) {
            String msg = "Failed to resolve the input source to a URI (" + ex.getMessage() + ").";
            throw new IOException(msg);
        }
        catch (WSDLException ex) {
            String msg = "Failed to instantiate a WSDLFactory (" + ex.getMessage() + ").";
            throw new IOException(msg);
        }
        catch (XmlException ex) {
            this.mLogger.error("Caught XMLException {}", (Object)ex.getMessage());
        }
        finally {
            Object attrs = null;
            if (null != byteStream) {
                byteStream.close();
                byteStream = null;
            }
            Object doc = null;
            Object documentation = null;
            Object httpClient = null;
            Object httpGet = null;
            Object imports = null;
            Object inputSource = null;
            Object locURI = null;
            Object schemas = null;
            Object types = null;
            Object wsdlAddress = null;
            Object wsdlFactory = null;
            Object wsdlReader = null;
            Object wsdlURL = null;
        }
    }

    private class ElementContent {
        String mDocumentation = null;
        QName mQName = null;
        String mXML = null;
        String mXMLSchema = null;
        String mXPath = null;

        ElementContent(QName qName) {
            this.mQName = qName;
        }

        public String getDocumentation() {
            return this.mDocumentation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OMElement getXMLAsOMElement() throws XMLStreamException {
            XMLStreamReader parser;
            StringReader stringReader;
            OMElement element = null;
            try {
                if (null != this.mXML) {
                    stringReader = new StringReader(this.mXML);
                    parser = XMLInputFactory.newInstance().createXMLStreamReader(stringReader);
                    element = OMXMLBuilderFactory.createStAXOMBuilder((XMLStreamReader)parser).getDocumentElement();
                    element.build();
                    element = WSDLDiscovery.this.cleanseXML(null, element, false);
                    stringReader.close();
                }
                OMElement oMElement = element;
                return oMElement;
            }
            finally {
                parser = null;
                stringReader = null;
            }
        }

        public String getXML() {
            return this.mXML;
        }

        public String getXMLSchema() {
            return this.mXMLSchema;
        }

        public String getXPath() {
            return this.mXPath;
        }

        public void setDocumentation(String doc) {
            this.mDocumentation = doc;
        }

        public void setXML(String xml) {
            this.mXML = xml;
        }

        public void setXMLSchema(String schema) {
            this.mXMLSchema = schema;
        }

        public void setXPath(String xpath) {
            this.mXPath = xpath;
        }
    }
}

