import java.util.regex.Pattern
import java.text.SimpleDateFormat

//
// The purpose of this script is to patch files that are part of cfgwizard
//

class updatecfgwizard {

   public static myClassName = updatecfgwizard.class.getName()
   public static myFQFN      = updatecfgwizard.class.protectionDomain.codeSource.location.path
   public static date        = new Date()
   public static sdf         = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss")
   public static startTS     = sdf.format(date)
   public static finalRC     = new Integer(0)

   static void main(String[] args) {
      println ""
      println updatecfgwizard.myClassName + ".groovy main entry"
      println updatecfgwizard.myFQFN
      println startTS

      HashMap argsHashMap = new HashMap()
      def changeWasMade   = false

      // Parse all key=value pairs.  If no value, then use zero length string
      for (String arg : args) {
         String[] strkey = new String()
         strkey = arg.split( '=' )
         if ( strkey.length > 1 ) {
           argsHashMap.put( strkey[0], strkey[1] )
         }
         else {
           argsHashMap.put( strkey[0], '' )
         }
      }

      // for (String s : argsHashMap.keySet()) {
      //    println s + " is " + argsHashMap.get(s)
      // }

      if ( false == argsHashMap.containsKey('SASHome') ) {
         println "Failure:  Missing required parameter 'SASHome=<SASHome>' for " + updatecfgwizard.myClassName + ".groovy"
         System.exit( 1 )
      }

      def SASHome = argsHashMap.get( 'SASHome' ).trim()
      if (SASHome.endsWith("/") || SASHome.endsWith("\\")) {
         SASHome = SASHome.substring(0, SASHome.length() - 1)
      }

      println "SASHome: '$SASHome'"
      println "Java:    " + System.getProperty("java.version")
      println "Groovy:  " + getGroovyVersion()

      // ----------------------------------------
      // Find most recent cfgwizard directory
      // ----------------------------------------
      def cfgwizardDir = ""
      cfgwizardDir = findCfgwizardDir( SASHome )

      // ----------------------------------------
      // Patch file:       \SASHome\SASDeploymentManager\9.4\products\cfgwizard__XXX\Utilities\configuration_scripts.xml
      // In macro:         <macrodef name="changeLoginDomain">
      // For Java call:    <java taskname="ChangeLoginDomain"
      // Comment out arg:  <arg value="${listopt}" />
      // See Jira:         SDWIT-412
      // ----------------------------------------
      if ( cfgwizardDir.length() > 0 && 0 == finalRC )
      {
         changeWasMade = patchChangeLoginDomain( cfgwizardDir )
      }

      // ----------------------------------------
      def endDate = new Date()
      def endTS   = sdf.format(endDate)
      println endTS
      println updatecfgwizard.myClassName + ".groovy main exit  RC: '" + finalRC + "'"
      System.exit( finalRC )
   }


   // --------------------------------------------------------------------
   // Find most recent cfgwizard directory
   // --------------------------------------------------------------------
   static findCfgwizardDir( SASHome ) {
      println "entry findCfgwizardDir  SASHome: '" + SASHome + "'"

      def productsDirStr = SASHome + File.separator + "SASDeploymentManager" + File.separator + "9.4" + File.separator + "products"
      def productsDir    = new File( productsDirStr )
      def cfgwizardDir   = ""

      productsDir.eachDirMatch(~/cfgwizard__94[0-9][0-9][0-9]__prt__.*/) {
         println "Found directory '" + it.getAbsolutePath() + "'"

         if ( cfgwizardDir.compareTo( it.getAbsolutePath() ) < 0 ) {
            cfgwizardDir = it.getAbsolutePath()
         }
      }

      if ( cfgwizardDir.length() == 0 )
      {
         println "Patch to configuration_scripts.xml was not performed because a cfgwizard directory was found in '" + productsDir.getAbsolutePath() + "'"
         finalRC = 1
      }

      println "exit findCfgwizardDir  cfgwizardDir: '" + cfgwizardDir + "'  finalRC: '" + finalRC + "'"
      return cfgwizardDir
   }


   // --------------------------------------------------------------------
   // Patch macrodef changeLoginDomain
   // --------------------------------------------------------------------
   static patchChangeLoginDomain( cfgwizardDir ) {

      println "entry patchChangeLoginDomain  cfgwizardDir: '" + cfgwizardDir + "'"

      def configurationScriptsFQFN = cfgwizardDir + File.separator + "Utilities" + File.separator + "configuration_scripts.xml"
      def configurationScriptsFile = new File( configurationScriptsFQFN )
      def changeWasMade            = false

      // The key lines in configuration_scripts.xml that we are looking for:
      //   <macrodef name="changeLoginDomain">
      //   <arg value="${listopt}" />
      //   </macrodef>
      // Escape characters must be double escaped as in "\\".
      // [ \t]* is zero or more instances of blanks/tabs

      Pattern changeLoginDomainPattern   = Pattern.compile('(?i)^[ \t]*<macrodef name\\="changeLoginDomain">[ \t]*$');
      Pattern listoptPattern             = Pattern.compile('(?i)^[ \t]*<arg value\\="\\$\\{listopt\\}" />[ \t]*$');
      Pattern endMacrodefPattern         = Pattern.compile('(?i)^[ \t]*</macrodef>[ \t]*$');

      Pattern listoptPatternReplacer     = Pattern.compile('(?i)<arg value\\="\\$\\{listopt\\}" />');

      if ( configurationScriptsFile.exists() )
      {
         println "Found file '" + configurationScriptsFile.getAbsolutePath() + "'"
         try {
            def lineCounter = 0
            def outputLines = []
            def foundChangeLoginDomain = false
            def foundListopt           = false

            // Read the file a line at a time
            configurationScriptsFile.withReader { reader ->
               def line = reader.readLine()
               while (null != line) {

                  // println "Line read in:  '$line'"

                  lineCounter++

                  // If found the macrodef that needs patching
                  if (changeLoginDomainPattern.matcher(line).matches()) {
                     println "Line " + lineCounter + ":  Found the key macrodef: '" + line + "'"
                     foundChangeLoginDomain = true
                  }
                  // If found the specific line that needs patching
                  else if (listoptPattern.matcher(line).matches()) {
                     println "Line " + lineCounter + ":  Found line to change: '" + line + "'"
                     foundListopt = true
                  }
                  // If found the generic end statement of any macrodef
                  else if (endMacrodefPattern.matcher(line).matches()) {
                     // To cut down the noise in the log, only print out the ending macrodef of the one that we are interested in
                     if ( true == foundChangeLoginDomain ) {
                        println "Line " + lineCounter + ":  Found ending macrodef: '" + line + "'"
                     }
                     foundChangeLoginDomain = false  // Make sure this is false when stumbling into an ending macrodef.
                  }

                  def newLine = line  // Prime the potentially changed line with the original line.  Will override later if a change is needed.

                  // Patch this only ONLY if the specific line is within the specific macrodef
                  if ( true == foundListopt ) {
                     if ( true == foundChangeLoginDomain ) {

                        newLine = listoptPatternReplacer.matcher(line).replaceAll('<!-- <arg value\\="\\$\\{listopt\\}" /> -->')

                        println "Line " + lineCounter + ":  New commented out line: '" + newLine + "'"

                        changeWasMade = true
                     }
                     else
                     {
                        println "Line " + lineCounter + ":  Warning:  Found line '" + line + "' but found it outside of '<macrodef name=\"changeLoginDomain\">'.  Quietly ignoring."
                     }
                     foundListopt = false
                  }

                  outputLines.add( newLine )

                  line = reader.readLine()
               }
            }

            if ( true == changeWasMade ) {

               def existingFQFN = configurationScriptsFile.getAbsolutePath()

               // Rename/backup existing file
               def backupFQFN = configurationScriptsFile.getAbsolutePath() + ".bak_" + startTS
               def backupFile = new File( backupFQFN )
               configurationScriptsFile.renameTo backupFile
               println "Backup file: '" + backupFile.getAbsolutePath() + "'"

               // Recreate existing file with the changed contents
               new File(existingFQFN).withWriter { writer ->
                   outputLines.each { line ->
                       writer.writeLine line
                   }
               }
               println "Change made to file: '" + configurationScriptsFile.getAbsolutePath() + "'"
            }
            else {
               println "No change was made"
            }
         }
         catch(Exception e) {
            println "Failure:  Exception thrown:"
            println e
            finalRC = 1
         }
      }
      else  {
         println "Patching failed because file does not exist:  '" + configurationScriptsFQFN + "'"
         finalRC = 1
      }

      println "exit patchChangeLoginDomain  changeWasMade: '" + changeWasMade + "'  finalRC: '" + finalRC + "'"
      return changeWasMade
   }

   static String getGroovyVersion()
   {
      try {
         // Supposed to work for groovy before 1.6.6
         return org.codehaus.groovy.runtime.InvokerHelper.getVersion()
      }
      catch (Throwable ignore) {
         return GroovySystem.version
      }
   }
}
