@echo off
REM updatecfgwizard.bat
REM
REM Used as a wrapper for groovy script updatecfgwizard.groovy.
REM Patches a file delivered by cfgwizard under /SASHome/SASDeploymentManager/9.4/products/cfgwizard__*
REM
REM Args:
REM   1 - SASHome, required
REM   2 - "-ignoreError", optional. Used by BigFix to ignore all errors, and always return a 0 RC
REM
REM Must use EnableDelayedExpansion, and use the !xxxx! syntax in order to use real time values for the env vars.
REM   https://stackoverflow.com/questions/9102422/windows-batch-set-inside-if-not-working/49522505
REM
setlocal EnableDelayedExpansion

set currentDir=%~dp0
set myFileName=%~n0
for /f "tokens=2-4 delims=/ " %%a in ("%DATE%") do (set myDate=%%c-%%a-%%b)
for /f "tokens=1-3 delims=:." %%a in ("%TIME%") do (set myTime=%%a-%%b-%%c)
set currentTS=%myDate%_%myTime%
set logFQFN=!currentDir!!myFileName!_!currentTS!.log
set finalRC=0
set ignoreError=

echo %~0 entry  1>"!logFQFN!" 2>&1
date /t        1>>"!logFQFN!" 2>&1
time /t        1>>"!logFQFN!" 2>&1
echo.          1>>"!logFQFN!" 2>&1

if "%~1"=="" (
  echo "No parameter <SASHome> was specified. Please try again."
  echo "No parameter <SASHome> was specified. Please try again."  1>>"!logFQFN!" 2>&1
  set finalRC=1
  goto endfile
)

REM Handle SASHome arg.  Copy arg1 and remove quotes if any
set SASHome=%~1

REM Trim up to 30 spaces from the beginning of SASHome
for /l %%a in (1,1,30) do if "!SASHome:~0,1!"==" " set SASHome=!SASHome:~1!

REM Trim up to 30 spaces from the end of SASHome (the previous loop somehow just moves to the spaces to the end rather than removing them, so bump counter to 60 to remove the worst case scenario)
for /l %%a in (1,1,60) do if "!SASHome:~-1!"==" " set SASHome=!SASHome:~0,-1!

REM Handle optional ignoreError arg.
if not "%~2"=="" (
  REM Copy arg2 and remove quotes if any
  set ignoreError=%~2

  REM Trim up to 30 spaces from the beginning of ignoreError
  for /l %%a in (1,1,30) do if "!ignoreError:~0,1!"==" " set ignoreError=!ignoreError:~1!

  REM Trim up to 30 spaces from the end of ignoreError (the previous loop somehow just moves to the spaces to the end rather than removing them, so bump counter to 60 to remove the worst case scenario)
  for /l %%a in (1,1,60) do if "!ignoreError:~-1!"==" " set ignoreError=!ignoreError:~0,-1!

  if not "!ignoreError!"=="-ignoreError" (
    echo Warning:  Arg 2 is unrecognized '!ignoreError!'.  Expecting this to be '-ignoreError'.  Ignoring.
    echo Warning:  Arg 2 is unrecognized '!ignoreError!'.  Expecting this to be '-ignoreError'.  Ignoring.  1>>"!logFQFN!" 2>&1
  )
)

REM Remove trailing slash from SASHome if there is one
if "!SASHome:~-1!"=="\" set SASHome=!SASHome:~0,-1!

echo SASHome=!SASHome!  1>>"!logFQFN!" 2>&1

REM Check to see if the SASHome is a valid directory
if not exist "!SASHome!" (
  echo SASHome '!SASHome!' is not a valid directory.
  echo SASHome '!SASHome!' is not a valid directory.  1>>"!logFQFN!" 2>&1
  set finalRC=1
  goto checkIgnoreErrorAndExit
)

REM Locate the SAS delivered JRE to use
findstr /b /c:"JREHOME" "!SASHome!\sassw.config" > !myFileName!_jre_temp.txt
set /p JRETEMP= < !myFileName!_jre_temp.txt
set SASPrivateJRE=!JRETEMP:~8!
del !myFileName!_jre_temp.txt
echo SASPrivateJRE=!SASPrivateJRE!  1>>"!logFQFN!" 2>&1

REM Check to see if the SASPrivateJRE is a valid file
if not exist "!SASPrivateJRE!" (
  echo SASPrivateJRE '!SASPrivateJRE!' is not a valid file.
  echo SASPrivateJRE '!SASPrivateJRE!' is not a valid file.  1>>"!logFQFN!" 2>&1
  set finalRC=1
  goto checkIgnoreErrorAndExit
)

REM Locate most recent deploywiz, sorted
for /f %%a in ( 'dir /b /a:d /o:n "!SASHome!\SASDeploymentManager\9.4\products\deploywiz__94*__prt__*"' ) ^
do (
  set deploywiz_dir=!SASHome!\SASDeploymentManager\9.4\products\%%~na
)

echo deploywiz_dir=!deploywiz_dir!  1>>"!logFQFN!" 2>&1
echo logFQFN=!logFQFN!              1>>"!logFQFN!" 2>&1
echo.                               1>>"!logFQFN!" 2>&1

REM Execute groovy script
echo "!SASPrivateJRE!" -cp "!deploywiz_dir!\deploywiz\groovy\*;!deploywiz_dir!\deploywiz\*" groovy.lang.GroovyShell "!currentDir!!myFileName!.groovy" "SASHome=!SASHome!"  1>>"!logFQFN!" 2>&1
     "!SASPrivateJRE!" -cp "!deploywiz_dir!\deploywiz\groovy\*;!deploywiz_dir!\deploywiz\*" groovy.lang.GroovyShell "!currentDir!!myFileName!.groovy" "SASHome=!SASHome!"  1>>"!logFQFN!" 2>&1
set finalRC=%ERRORLEVEL%

echo.                                  1>>"!logFQFN!" 2>&1
echo !myFileName!.groovy RC=!finalRC!  1>>"!logFQFN!" 2>&1
echo.                                  1>>"!logFQFN!" 2>&1

if "!finalRC!"=="0" (
  echo Finished.  See log file:  !logFQFN!
  echo Finished.  See log file:  !logFQFN!  1>>"!logFQFN!" 2>&1
  goto endfile
)

echo Failure detected by the groovy script.  See log file:  !logFQFN!
echo Failure detected by the groovy script.  See log file:  !logFQFN!  1>>"!logFQFN!" 2>&1

:checkIgnoreErrorAndExit
if "!ignoreError!"=="-ignoreError" (
  echo Ignoring all errors, always returning a 0 RC, to not disrupt the caller.
  echo Ignoring all errors, always returning a 0 RC, to not disrupt the caller.  1>>"!logFQFN!" 2>&1
  set finalRC=0
)

:endfile
echo.                       1>>"!logFQFN!" 2>&1
date /t                     1>>"!logFQFN!" 2>&1
time /t                     1>>"!logFQFN!" 2>&1
echo %~0 exit RC !finalRC!
echo %~0 exit RC !finalRC!  1>>"!logFQFN!" 2>&1
exit /b !finalRC!
